/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.domain.mapper;

import io.domainlifecycles.diagram.domain.config.DomainDiagramConfig;
import io.domainlifecycles.diagram.domain.mapper.DomainMapperUtils;
import io.domainlifecycles.diagram.domain.mapper.FilteredDomainClasses;
import io.domainlifecycles.diagram.nomnoml.NomnomlRelationship;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.ApplicationServiceMirror;
import io.domainlifecycles.mirror.api.AssertionMirror;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.api.DomainCommandProcessingMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainObjectMirror;
import io.domainlifecycles.mirror.api.DomainServiceMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityMirror;
import io.domainlifecycles.mirror.api.EntityReferenceMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.OutboundServiceMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import io.domainlifecycles.mirror.api.ValueReferenceMirror;
import io.domainlifecycles.mirror.model.AssertionType;
import io.domainlifecycles.mirror.visitor.ContextDomainObjectVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class DomainRelationshipMapper {
    private final DomainDiagramConfig diagramConfig;
    private final DomainMirror domainMirror;
    private final FilteredDomainClasses filteredDomainClasses;

    public DomainRelationshipMapper(DomainDiagramConfig diagramConfig, DomainMirror domainMirror, FilteredDomainClasses filteredDomainClasses) {
        this.diagramConfig = diagramConfig;
        this.domainMirror = domainMirror;
        this.filteredDomainClasses = filteredDomainClasses;
    }

    public List<NomnomlRelationship> mapAllServiceKindRelationships() {
        ArrayList<NomnomlRelationship> relationShips = new ArrayList<NomnomlRelationship>();
        this.filteredDomainClasses.getServiceKinds().forEach(s -> s.getReferencedServiceKinds().stream().filter(this.filteredDomainClasses::contains).forEach(t -> relationShips.add(this.mapServiceKindRelationship((ServiceKindMirror)s, (ServiceKindMirror)t))));
        if (this.diagramConfig.getGeneralVisualSettings().isShowAllAbstractTypes()) {
            this.filteredDomainClasses.getServiceKinds().forEach(s -> {
                relationShips.addAll(this.mapImplementsInterface((DomainTypeMirror)s));
                this.mapInheritance((DomainTypeMirror)s).ifPresent(relationShips::add);
            });
        }
        return relationShips;
    }

    public List<NomnomlRelationship> mapAllAggregateRepositoryRelationships() {
        ArrayList<NomnomlRelationship> relationShips = new ArrayList<NomnomlRelationship>();
        this.filteredDomainClasses.getRepositories().stream().filter(r -> {
            if (r.getManagedAggregate().isPresent()) {
                return this.filteredDomainClasses.contains((DomainTypeMirror)r.getManagedAggregate().get());
            }
            return false;
        }).forEach(r -> relationShips.add(this.mapAggregateRepositoryRelationship((RepositoryMirror)r)));
        return relationShips;
    }

    public List<NomnomlRelationship> mapAllQueryHandlerReadModelRelationships() {
        ArrayList<NomnomlRelationship> relationShips = new ArrayList<NomnomlRelationship>();
        if (this.diagramConfig.getGeneralVisualSettings().isShowQueryHandlers() && this.diagramConfig.getGeneralVisualSettings().isShowReadModels()) {
            this.filteredDomainClasses.getQueryHandlers().stream().filter(r -> {
                if (r.getProvidedReadModel().isPresent()) {
                    return this.filteredDomainClasses.contains((DomainTypeMirror)r.getProvidedReadModel().get());
                }
                return false;
            }).forEach(r -> relationShips.add(this.mapQueryHandlerReadModelRelationship((QueryHandlerMirror)r)));
        }
        return relationShips;
    }

    public List<NomnomlRelationship> mapAllAggregateFrameRelationships() {
        final ArrayList<NomnomlRelationship> relationShips = new ArrayList<NomnomlRelationship>();
        this.filteredDomainClasses.getAggregateRoots().forEach(ar -> {
            ContextDomainObjectVisitor visitor = new ContextDomainObjectVisitor((DomainObjectMirror)ar){

                public void visitValueReference(ValueReferenceMirror valueReferenceMirror) {
                    if (valueReferenceMirror.getValue().isIdentity() && !valueReferenceMirror.isIdentityField()) {
                        relationShips.addAll(DomainRelationshipMapper.this.mapFrameIdReferences(valueReferenceMirror));
                    }
                }
            };
            visitor.start();
        });
        for (NomnomlRelationship rel : relationShips) {
            int startIndex;
            for (int i = startIndex = relationShips.indexOf(rel); i < relationShips.size(); ++i) {
                NomnomlRelationship compared = relationShips.get(i);
                if (!compared.getFromName().equals(rel.getToName()) || !compared.getToName().equals(rel.getFromName())) continue;
                compared.transpose();
            }
        }
        return relationShips;
    }

    public List<NomnomlRelationship> mapAllDomainCommandRelationships() {
        ArrayList<NomnomlRelationship> relationShips = new ArrayList<NomnomlRelationship>();
        if (this.diagramConfig.getGeneralVisualSettings().isShowDomainCommands()) {
            if (this.diagramConfig.getGeneralVisualSettings().isShowAllAbstractTypes()) {
                this.filteredDomainClasses.getDomainCommands().forEach(s -> {
                    relationShips.addAll(this.mapImplementsInterface((DomainTypeMirror)s));
                    this.mapInheritance((DomainTypeMirror)s).ifPresent(relationShips::add);
                });
            }
            this.filteredDomainClasses.getDomainCommands().forEach(c -> {
                this.filteredDomainClasses.getAggregateRoots().forEach(ar -> {
                    if (ar.processes(c) && (!this.diagramConfig.getGeneralVisualSettings().isShowOnlyTopLevelDomainCommandRelations() || this.isTopLevelConsumerForCommand((DomainTypeMirror)ar, (DomainCommandMirror)c))) {
                        relationShips.add(this.mapDomainCommandAggregateRelationship((DomainCommandMirror)c, (AggregateRootMirror)ar));
                    }
                });
                this.filteredDomainClasses.getServiceKinds().forEach(ds -> {
                    if (ds.processes(c) && (!this.diagramConfig.getGeneralVisualSettings().isShowOnlyTopLevelDomainCommandRelations() || this.isTopLevelConsumerForCommand((DomainTypeMirror)ds, (DomainCommandMirror)c))) {
                        relationShips.add(this.mapDomainCommandServiceKindRelationship((DomainCommandMirror)c, (ServiceKindMirror)ds));
                    }
                });
            });
        }
        return relationShips;
    }

    private boolean isTopLevelConsumerForCommand(DomainTypeMirror domainTypeMirror, DomainCommandMirror domainCommandMirror) {
        List<DomainTypeMirror> typesReferencing = this.domainMirror.getAllDomainTypeMirrors().stream().filter(dt -> dt.getAllFields().stream().anyMatch(fm -> fm.getType().getTypeName().equals(domainTypeMirror.getTypeName()) || domainTypeMirror.getAllInterfaceTypeNames().stream().anyMatch(it -> fm.getType().getTypeName().equals(it)))).toList();
        if (domainTypeMirror.getDomainType().equals((Object)DomainType.AGGREGATE_ROOT)) {
            return this.domainMirror.getAllDomainTypeMirrors().stream().filter(dtm -> dtm instanceof DomainCommandProcessingMirror).filter(dtm -> dtm.getDomainType().equals((Object)DomainType.REPOSITORY) || dtm.getDomainType().equals((Object)DomainType.DOMAIN_SERVICE) || dtm.getDomainType().equals((Object)DomainType.APPLICATION_SERVICE)).map(dtm -> (DomainCommandProcessingMirror)dtm).noneMatch(d -> d.processes(domainCommandMirror));
        }
        Iterator<DomainTypeMirror> iterator = typesReferencing.iterator();
        if (iterator.hasNext()) {
            DomainTypeMirror referencingType = iterator.next();
            switch (referencingType.getDomainType()) {
                case AGGREGATE_ROOT: 
                case ENTITY: {
                    return !((EntityMirror)referencingType).processes(domainCommandMirror);
                }
                case REPOSITORY: {
                    return !((RepositoryMirror)referencingType).processes(domainCommandMirror);
                }
                case DOMAIN_SERVICE: {
                    return !((DomainServiceMirror)referencingType).processes(domainCommandMirror);
                }
                case APPLICATION_SERVICE: {
                    return !((ApplicationServiceMirror)referencingType).processes(domainCommandMirror);
                }
                case OUTBOUND_SERVICE: {
                    return !((OutboundServiceMirror)referencingType).processes(domainCommandMirror);
                }
                case QUERY_HANDLER: {
                    return !((QueryHandlerMirror)referencingType).processes(domainCommandMirror);
                }
                case SERVICE_KIND: {
                    return !((ServiceKindMirror)referencingType).processes(domainCommandMirror);
                }
            }
            return true;
        }
        return true;
    }

    public List<NomnomlRelationship> mapAllDomainEventRelationships() {
        ArrayList<NomnomlRelationship> relationShips = new ArrayList<NomnomlRelationship>();
        if (this.diagramConfig.getGeneralVisualSettings().isShowAllAbstractTypes()) {
            this.filteredDomainClasses.getDomainEvents().forEach(s -> {
                relationShips.addAll(this.mapImplementsInterface((DomainTypeMirror)s));
                this.mapInheritance((DomainTypeMirror)s).ifPresent(relationShips::add);
            });
        }
        this.filteredDomainClasses.getDomainEvents().forEach(de -> {
            this.filteredDomainClasses.getServiceKinds().forEach(s -> {
                if (s.publishes(de)) {
                    relationShips.add(this.mapPublishesDomainEvent((DomainTypeMirror)s, (DomainEventMirror)de));
                }
                if (s.listensTo(de)) {
                    relationShips.add(this.mapListensToDomainEvent((DomainTypeMirror)s, (DomainEventMirror)de));
                }
            });
            this.filteredDomainClasses.getAggregateRoots().forEach(a -> {
                if (a.publishes(de)) {
                    relationShips.add(this.mapAggregatePublishesDomainEvent((AggregateRootMirror)a, (DomainEventMirror)de));
                }
                if (a.listensTo(de)) {
                    relationShips.add(this.mapAggregateListensToDomainEvent((AggregateRootMirror)a, (DomainEventMirror)de));
                }
            });
        });
        return relationShips;
    }

    private NomnomlRelationship mapAggregateRepositoryRelationship(RepositoryMirror repositoryMirror) {
        return NomnomlRelationship.builder().fromName(this.relationConnectorName((DomainTypeMirror)repositoryMirror)).fromMultiplicity("").fromStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)repositoryMirror)).label("").relationshiptype(NomnomlRelationship.RelationshipType.ASSOCIATION).toStyleClassifier("<AF> ").toMultiplicity("").toName(DomainMapperUtils.mapTypeName(repositoryMirror.getManagedAggregate().map(DomainTypeMirror::getTypeName).orElse("java.lang.Object"), this.diagramConfig) + " <<Aggregate>>").build();
    }

    private NomnomlRelationship mapQueryHandlerReadModelRelationship(QueryHandlerMirror queryHandlerMirror) {
        return NomnomlRelationship.builder().fromName(this.relationConnectorName((DomainTypeMirror)queryHandlerMirror)).fromMultiplicity("").fromStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)queryHandlerMirror)).label("").relationshiptype(NomnomlRelationship.RelationshipType.ASSOCIATION).toStyleClassifier(DomainMapperUtils.styleClassifier(queryHandlerMirror.getProvidedReadModel().orElse(null))).toMultiplicity("").toName(this.relationConnectorName((DomainTypeMirror)queryHandlerMirror.getProvidedReadModel().orElse(null))).build();
    }

    private NomnomlRelationship mapServiceKindRelationship(ServiceKindMirror serviceKindMirrorFrom, ServiceKindMirror serviceKindMirrorTo) {
        return NomnomlRelationship.builder().fromName(this.relationConnectorName((DomainTypeMirror)serviceKindMirrorFrom)).fromMultiplicity("").fromStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)serviceKindMirrorFrom)).label("").relationshiptype(NomnomlRelationship.RelationshipType.ASSOCIATION).toName(this.relationConnectorName((DomainTypeMirror)serviceKindMirrorTo)).toMultiplicity("").toStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)serviceKindMirrorTo)).build();
    }

    private NomnomlRelationship mapListensToDomainEvent(DomainTypeMirror domainTypeMirror, DomainEventMirror domainEventMirror) {
        return NomnomlRelationship.builder().fromName(this.relationConnectorName((DomainTypeMirror)domainEventMirror)).fromMultiplicity("").fromStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)domainEventMirror)).label("").relationshiptype(NomnomlRelationship.RelationshipType.DIRECTED_ASSOCIATION).toName(this.relationConnectorName(domainTypeMirror)).toMultiplicity("").toStyleClassifier(DomainMapperUtils.styleClassifier(domainTypeMirror)).build();
    }

    private NomnomlRelationship mapAggregateListensToDomainEvent(AggregateRootMirror aggregateRootMirror, DomainEventMirror domainEventMirror) {
        return NomnomlRelationship.builder().fromName(this.relationConnectorName((DomainTypeMirror)domainEventMirror)).fromMultiplicity("").fromStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)domainEventMirror)).label("").relationshiptype(NomnomlRelationship.RelationshipType.DIRECTED_ASSOCIATION).toName(DomainMapperUtils.mapTypeName(aggregateRootMirror.getTypeName(), this.diagramConfig) + " <<Aggregate>>").toMultiplicity("").toStyleClassifier(DomainMapperUtils.styleClassifier(null)).build();
    }

    private NomnomlRelationship mapPublishesDomainEvent(DomainTypeMirror domainTypeMirror, DomainEventMirror domainEventMirror) {
        return NomnomlRelationship.builder().fromName(this.relationConnectorName(domainTypeMirror)).fromMultiplicity("").fromStyleClassifier(DomainMapperUtils.styleClassifier(domainTypeMirror)).label("").relationshiptype(NomnomlRelationship.RelationshipType.DIRECTED_ASSOCIATION).toName(this.relationConnectorName((DomainTypeMirror)domainEventMirror)).toMultiplicity("").toStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)domainEventMirror)).build();
    }

    private NomnomlRelationship mapAggregatePublishesDomainEvent(AggregateRootMirror aggregateRootMirror, DomainEventMirror domainEventMirror) {
        return NomnomlRelationship.builder().fromName(DomainMapperUtils.mapTypeName(aggregateRootMirror.getTypeName(), this.diagramConfig) + " <<Aggregate>>").fromMultiplicity("").fromStyleClassifier("<AF> ").label("").relationshiptype(NomnomlRelationship.RelationshipType.DIRECTED_ASSOCIATION).toName(this.relationConnectorName((DomainTypeMirror)domainEventMirror)).toMultiplicity("").toStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)domainEventMirror)).build();
    }

    private NomnomlRelationship mapDomainCommandServiceKindRelationship(DomainCommandMirror domainCommandMirror, ServiceKindMirror serviceKindMirror) {
        return NomnomlRelationship.builder().fromName(this.relationConnectorName((DomainTypeMirror)domainCommandMirror)).fromMultiplicity("").fromStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)domainCommandMirror)).label("").relationshiptype(NomnomlRelationship.RelationshipType.DIRECTED_ASSOCIATION).toName(this.relationConnectorName((DomainTypeMirror)serviceKindMirror)).toMultiplicity("").toStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)serviceKindMirror)).build();
    }

    private NomnomlRelationship mapDomainCommandAggregateRelationship(DomainCommandMirror domainCommandMirror, AggregateRootMirror aggregateRootMirror) {
        return NomnomlRelationship.builder().fromName(this.relationConnectorName((DomainTypeMirror)domainCommandMirror)).fromMultiplicity("").fromStyleClassifier(DomainMapperUtils.styleClassifier((DomainTypeMirror)domainCommandMirror)).label("").relationshiptype(NomnomlRelationship.RelationshipType.DIRECTED_ASSOCIATION).toStyleClassifier("<AF> ").toMultiplicity("").toName(DomainMapperUtils.mapTypeName(aggregateRootMirror.getTypeName(), this.diagramConfig) + " <<Aggregate>>").build();
    }

    public List<NomnomlRelationship> mapAllAggregateRelationships(final AggregateRootMirror aggregateRootMirror) {
        final ArrayList<NomnomlRelationship> relationShips = new ArrayList<NomnomlRelationship>();
        ContextDomainObjectVisitor visitor = new ContextDomainObjectVisitor((DomainObjectMirror)aggregateRootMirror){

            public void visitEntityReference(EntityReferenceMirror entityReferenceMirror) {
                relationShips.add(DomainRelationshipMapper.this.mapEntityReference(entityReferenceMirror));
            }

            public void visitValueReference(ValueReferenceMirror valueReferenceMirror) {
                if (!DomainMapperUtils.showPropertyInline((FieldMirror)valueReferenceMirror, (DomainTypeMirror)aggregateRootMirror, DomainRelationshipMapper.this.diagramConfig)) {
                    relationShips.add(DomainRelationshipMapper.this.mapValueReference(valueReferenceMirror));
                }
            }

            public void visitEnterAnyDomainType(DomainTypeMirror domainTypeMirror) {
                block3: {
                    block2: {
                        if (DomainRelationshipMapper.this.diagramConfig.getGeneralVisualSettings().isShowAbstractTypesInAggregates()) break block2;
                        if (!DomainRelationshipMapper.this.diagramConfig.getGeneralVisualSettings().isShowAllAbstractTypes()) break block3;
                    }
                    DomainRelationshipMapper.this.mapInheritance(domainTypeMirror).ifPresent(relationShips::add);
                    relationShips.addAll(DomainRelationshipMapper.this.mapImplementsInterface(domainTypeMirror));
                }
            }
        };
        visitor.start();
        return relationShips;
    }

    private Optional<NomnomlRelationship> mapInheritance(DomainTypeMirror domainTypeMirror) {
        Optional superType;
        String superClassName;
        if (domainTypeMirror.getInheritanceHierarchyTypeNames() != null && !domainTypeMirror.getInheritanceHierarchyTypeNames().isEmpty() && !(superClassName = (String)domainTypeMirror.getInheritanceHierarchyTypeNames().get(0)).startsWith("io.domainlifecycles") && (superType = this.domainMirror.getDomainTypeMirror(superClassName)).isPresent() && this.filteredDomainClasses.contains((DomainTypeMirror)superType.get())) {
            return Optional.of(NomnomlRelationship.builder().fromName(this.relationConnectorName(superClassName)).fromStyleClassifier(DomainMapperUtils.styleClassifier(this.domainMirror.getDomainTypeMirror(superClassName).orElse(null))).fromMultiplicity("").label("").toName(this.relationConnectorName(domainTypeMirror)).toStyleClassifier(DomainMapperUtils.styleClassifier(domainTypeMirror)).toMultiplicity("").relationshiptype(NomnomlRelationship.RelationshipType.INHERITANCE).build());
        }
        return Optional.empty();
    }

    private List<NomnomlRelationship> mapImplementsInterface(DomainTypeMirror domainTypeMirror) {
        if (domainTypeMirror.getAllInterfaceTypeNames() != null) {
            return domainTypeMirror.getAllInterfaceTypeNames().stream().filter(interfaceName -> !interfaceName.startsWith("io.domainlifecycles")).map(arg_0 -> ((DomainMirror)this.domainMirror).getDomainTypeMirror(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(this.filteredDomainClasses::contains).map(i -> NomnomlRelationship.builder().fromName(this.relationConnectorName((DomainTypeMirror)i)).fromStyleClassifier(DomainMapperUtils.styleClassifier(i)).fromMultiplicity("").label("").toName(this.relationConnectorName(domainTypeMirror)).toStyleClassifier(DomainMapperUtils.styleClassifier(domainTypeMirror)).toMultiplicity("").relationshiptype(NomnomlRelationship.RelationshipType.INHERITANCE).build()).toList();
        }
        return Collections.emptyList();
    }

    private NomnomlRelationship mapEntityReference(EntityReferenceMirror entityReferenceMirror) {
        String toMultiplicity = this.toMultiplicity((FieldMirror)entityReferenceMirror);
        Object label = entityReferenceMirror.getName();
        if (this.diagramConfig.getGeneralVisualSettings().isMultiplicityInLabel()) {
            label = (String)label + " " + toMultiplicity;
            toMultiplicity = "";
        }
        return NomnomlRelationship.builder().fromName(this.relationConnectorName(entityReferenceMirror.getDeclaredByTypeName())).fromMultiplicity("").fromStyleClassifier(DomainMapperUtils.styleClassifier(this.domainMirror.getDomainTypeMirror(entityReferenceMirror.getDeclaredByTypeName()).orElse(null))).label((String)label).toStyleClassifier(DomainMapperUtils.styleClassifier(this.domainMirror.getDomainTypeMirror(entityReferenceMirror.getType().getTypeName()).orElse(null))).toMultiplicity(toMultiplicity).toName(this.relationConnectorName(entityReferenceMirror.getType().getTypeName())).relationshiptype(NomnomlRelationship.RelationshipType.COMPOSITION).build();
    }

    private NomnomlRelationship mapValueReference(ValueReferenceMirror valueReferenceMirror) {
        String toMultiplicity = this.toMultiplicity((FieldMirror)valueReferenceMirror);
        Object label = valueReferenceMirror.getName();
        if (this.diagramConfig.getGeneralVisualSettings().isMultiplicityInLabel()) {
            label = (String)label + " " + toMultiplicity;
            toMultiplicity = "";
        }
        return NomnomlRelationship.builder().fromName(this.relationConnectorName(valueReferenceMirror.getDeclaredByTypeName())).fromMultiplicity("").fromStyleClassifier(DomainMapperUtils.styleClassifier(this.domainMirror.getDomainTypeMirror(valueReferenceMirror.getDeclaredByTypeName()).orElse(null))).label((String)label).toStyleClassifier(DomainMapperUtils.styleClassifier(this.domainMirror.getDomainTypeMirror(valueReferenceMirror.getType().getTypeName()).orElse(null))).toMultiplicity(toMultiplicity).toName(this.relationConnectorName(valueReferenceMirror.getType().getTypeName())).relationshiptype(NomnomlRelationship.RelationshipType.AGGREGATION).build();
    }

    private List<NomnomlRelationship> mapFrameIdReferences(final ValueReferenceMirror idReferenceMirror) {
        List<AggregateRootMirror> declaringAggregates = this.filteredDomainClasses.getAggregateRoots().stream().filter(aggregateRootMirror -> {
            final AtomicBoolean contained = new AtomicBoolean(false);
            ContextDomainObjectVisitor visitor = new ContextDomainObjectVisitor((DomainObjectMirror)aggregateRootMirror){

                public void visitValueReference(ValueReferenceMirror valueReferenceMirror) {
                    if (idReferenceMirror.equals(valueReferenceMirror)) {
                        contained.set(true);
                    }
                }
            };
            visitor.start();
            return contained.get();
        }).toList();
        Optional<AggregateRootMirror> targetAggregate = this.filteredDomainClasses.getAggregateRoots().stream().filter(aggregateRootMirror -> {
            Optional identity = aggregateRootMirror.getIdentityField();
            return identity.map(fieldMirror -> fieldMirror.getType().getTypeName().equals(idReferenceMirror.getValue().getTypeName())).orElse(false);
        }).findFirst();
        if (!declaringAggregates.isEmpty() && targetAggregate.isPresent()) {
            return declaringAggregates.stream().filter(decl -> !decl.getTypeName().equals(((AggregateRootMirror)targetAggregate.get()).getTypeName())).map(da -> NomnomlRelationship.builder().fromName(DomainMapperUtils.mapTypeName(da.getTypeName(), this.diagramConfig) + " <<Aggregate>>").fromMultiplicity("").fromStyleClassifier("<AF> ").label(DomainMapperUtils.mapTypeName(idReferenceMirror.getDeclaredByTypeName(), this.diagramConfig) + "." + idReferenceMirror.getName()).toStyleClassifier("<AF> ").toMultiplicity("").toName(DomainMapperUtils.mapTypeName(((AggregateRootMirror)targetAggregate.get()).getTypeName(), this.diagramConfig) + " <<Aggregate>>").relationshiptype(NomnomlRelationship.RelationshipType.DIRECTED_ASSOCIATION).build()).toList();
        }
        return Collections.emptyList();
    }

    private String relationConnectorName(DomainTypeMirror domainTypeMirror) {
        return DomainMapperUtils.domainTypeName(domainTypeMirror, this.diagramConfig) + this.connectorStereotype(domainTypeMirror.getTypeName());
    }

    private String relationConnectorName(String typeName) {
        return DomainMapperUtils.mapTypeName(typeName, this.diagramConfig) + this.connectorStereotype(typeName);
    }

    private String connectorStereotype(String typeName) {
        String stereotype;
        Optional domainTypeMirror = this.domainMirror.getDomainTypeMirror(typeName);
        if (domainTypeMirror.isPresent() && !"".equals(stereotype = DomainMapperUtils.stereotype((DomainTypeMirror)domainTypeMirror.get(), this.diagramConfig))) {
            return " <<" + stereotype + ">>";
        }
        return "";
    }

    private String toMultiplicity(FieldMirror propertyMirror) {
        if (propertyMirror.getType().hasOptionalContainer()) {
            return "0..1";
        }
        if (propertyMirror.getType().hasCollectionContainer()) {
            Optional<Integer> maxBySizeAssertions = propertyMirror.getType().getContainerAssertions().stream().filter(a -> AssertionType.hasSize.equals((Object)a.getAssertionType())).map(a -> {
                try {
                    return Integer.valueOf(a.getParam2());
                }
                catch (Throwable t) {
                    return Integer.MAX_VALUE;
                }
            }).min(Comparator.naturalOrder());
            Optional<Integer> minBySizeAssertions = propertyMirror.getType().getContainerAssertions().stream().filter(a -> AssertionType.hasSize.equals((Object)a.getAssertionType())).map(a -> {
                try {
                    return Integer.valueOf(a.getParam2());
                }
                catch (Throwable t) {
                    return 0;
                }
            }).min(Comparator.naturalOrder());
            Optional<Integer> minByMinAssertions = propertyMirror.getType().getContainerAssertions().stream().filter(a -> AssertionType.hasSizeMin.equals((Object)a.getAssertionType())).map(a -> {
                try {
                    return Integer.valueOf(a.getParam1());
                }
                catch (Throwable t) {
                    return 0;
                }
            }).max(Comparator.naturalOrder());
            Optional<Integer> maxByMaxAssertions = propertyMirror.getType().getContainerAssertions().stream().filter(a -> AssertionType.hasSizeMax.equals((Object)a.getAssertionType())).map(a -> {
                try {
                    return Integer.valueOf(a.getParam2());
                }
                catch (Throwable t) {
                    return Integer.MAX_VALUE;
                }
            }).min(Comparator.naturalOrder());
            Optional<Integer> minByNotEmptyAssertion = propertyMirror.getType().getContainerAssertions().stream().filter(a -> AssertionType.isNotEmptyIterable.equals((Object)a.getAssertionType())).findAny().map(a -> 1);
            int min = 0;
            int max = Integer.MAX_VALUE;
            if (minByNotEmptyAssertion.isPresent()) {
                min = 1;
            }
            if (minByMinAssertions.isPresent() && minByMinAssertions.get() > min) {
                min = minByMinAssertions.get();
            }
            if (minBySizeAssertions.isPresent() && minBySizeAssertions.get() > min) {
                min = minBySizeAssertions.get();
            }
            if (maxByMaxAssertions.isPresent() && maxByMaxAssertions.get() < max) {
                max = maxByMaxAssertions.get();
            }
            if (maxBySizeAssertions.isPresent() && maxBySizeAssertions.get() < max) {
                max = maxBySizeAssertions.get();
            }
            return min + ".." + String.valueOf(max == Integer.MAX_VALUE ? "*" : Integer.valueOf(max));
        }
        Optional<AssertionMirror> notNullAssertion = propertyMirror.getType().getAssertions().stream().filter(a -> AssertionType.isNotNull.equals((Object)a.getAssertionType())).findAny();
        if (notNullAssertion.isPresent()) {
            return "1";
        }
        return "0..1";
    }
}

