/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.domain.mapper;

import io.domainlifecycles.diagram.domain.config.DiagramTrimSettings;
import io.domainlifecycles.diagram.domain.config.GeneralVisualSettings;
import io.domainlifecycles.diagram.domain.mapper.DiagramSettingsFilter;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.ApplicationServiceMirror;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainServiceMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.OutboundServiceMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.ReadModelMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class FilteredDomainClasses {
    private final Set<DomainTypeMirror> includedDomainTypes;
    private final GeneralVisualSettings generalVisualSettings;

    public FilteredDomainClasses(DiagramTrimSettings diagramTrimSettings, GeneralVisualSettings generalVisualSettings, DomainMirror domainMirror) {
        Objects.requireNonNull(diagramTrimSettings, "diagramTrimSettings must not be null");
        this.generalVisualSettings = Objects.requireNonNull(generalVisualSettings, "generalVisualSettings must not be null");
        Objects.requireNonNull(domainMirror, "domainMirror must not be null");
        DiagramSettingsFilter diagramSettingsFilter = new DiagramSettingsFilter(domainMirror, diagramTrimSettings, generalVisualSettings);
        this.includedDomainTypes = domainMirror.getAllDomainTypeMirrors().stream().filter(diagramSettingsFilter::filter).collect(Collectors.toSet());
    }

    public boolean contains(DomainTypeMirror domainTypeMirror) {
        if (this.generalVisualSettings.isShowAllAbstractTypes()) {
            return this.includedDomainTypes.contains(domainTypeMirror);
        }
        return this.includedDomainTypes.stream().anyMatch(s -> s.getTypeName().equals(domainTypeMirror.getTypeName()) || s.getAllInterfaceTypeNames().contains(domainTypeMirror.getTypeName()) || s.getInheritanceHierarchyTypeNames().contains(domainTypeMirror.getTypeName()));
    }

    public List<DomainCommandMirror> getDomainCommands() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.DOMAIN_COMMAND)).map(dtm -> (DomainCommandMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }

    public List<DomainEventMirror> getDomainEvents() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.DOMAIN_EVENT)).map(dtm -> (DomainEventMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }

    public List<AggregateRootMirror> getAggregateRoots() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.AGGREGATE_ROOT)).map(dtm -> (AggregateRootMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }

    public List<ReadModelMirror> getReadModels() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.READ_MODEL)).map(dtm -> (ReadModelMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }

    public List<ServiceKindMirror> getServiceKinds() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.SERVICE_KIND) || dtm.getDomainType().equals((Object)DomainType.APPLICATION_SERVICE) || dtm.getDomainType().equals((Object)DomainType.DOMAIN_SERVICE) || dtm.getDomainType().equals((Object)DomainType.REPOSITORY) || dtm.getDomainType().equals((Object)DomainType.OUTBOUND_SERVICE) || dtm.getDomainType().equals((Object)DomainType.QUERY_HANDLER)).map(dtm -> (ServiceKindMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }

    public List<ApplicationServiceMirror> getApplicationServices() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.APPLICATION_SERVICE)).map(dtm -> (ApplicationServiceMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }

    public List<DomainServiceMirror> getDomainServices() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.DOMAIN_SERVICE)).map(dtm -> (DomainServiceMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }

    public List<RepositoryMirror> getRepositories() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.REPOSITORY)).map(dtm -> (RepositoryMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }

    public List<QueryHandlerMirror> getQueryHandlers() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.QUERY_HANDLER)).map(dtm -> (QueryHandlerMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }

    public List<OutboundServiceMirror> getOutboundServices() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.OUTBOUND_SERVICE)).map(dtm -> (OutboundServiceMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }

    public List<ServiceKindMirror> getUnspecifiedServiceKinds() {
        return this.includedDomainTypes.stream().filter(dtm -> dtm.getDomainType().equals((Object)DomainType.SERVICE_KIND)).map(dtm -> (ServiceKindMirror)dtm).sorted(Comparator.comparing(DomainTypeMirror::getTypeName)).toList();
    }
}

