/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.nomnoml;

import io.domainlifecycles.diagram.DiagramElement;
import io.domainlifecycles.diagram.nomnoml.NomnomlField;
import io.domainlifecycles.diagram.nomnoml.NomnomlMethod;
import io.domainlifecycles.diagram.nomnoml.NomnomlStereotype;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NomnomlClass
implements DiagramElement {
    private final Optional<String> comment;
    private final String name;
    private final String styleClassifier;
    private final List<NomnomlField> fields;
    private final List<NomnomlMethod> methods;
    private final List<NomnomlStereotype> stereotypes;
    private final boolean showFields;
    private final boolean showMethods;

    public NomnomlClass(String name, String comment, String styleClassifier, List<NomnomlField> fields, List<NomnomlMethod> methods, List<NomnomlStereotype> stereotypes, boolean showFields, boolean showMethods) {
        this.name = Objects.requireNonNull(name);
        this.comment = Optional.ofNullable(comment);
        this.styleClassifier = Objects.requireNonNull(styleClassifier);
        this.fields = Objects.requireNonNull(fields);
        this.methods = Objects.requireNonNull(methods);
        this.stereotypes = Objects.requireNonNull(stereotypes);
        this.showFields = showFields;
        this.showMethods = showMethods;
    }

    public static NomnomlClassBuilder builder() {
        return new NomnomlClassBuilder();
    }

    @Override
    public String getDiagramText() {
        StringBuilder builder = new StringBuilder();
        this.comment.ifPresent(s -> builder.append("// ").append((String)s).append(System.lineSeparator()));
        builder.append("[");
        builder.append(this.styleClassifier);
        builder.append(" ");
        builder.append(this.name);
        this.addStereotypes(builder);
        if (this.showFields) {
            builder.append("|");
            builder.append(System.lineSeparator());
            this.addFields(builder);
        }
        if (this.showMethods) {
            builder.append("|");
            builder.append(System.lineSeparator());
            this.addMethods(builder);
        }
        builder.append("]");
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    private void addStereotypes(StringBuilder builder) {
        this.stereotypes.forEach(s -> {
            builder.append(" ");
            builder.append(s.getDiagramText());
            builder.append(" ");
        });
    }

    private void addFields(StringBuilder builder) {
        this.fields.forEach(f -> builder.append(f.getDiagramText()));
    }

    private void addMethods(StringBuilder builder) {
        this.methods.forEach(f -> builder.append(f.getDiagramText()));
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public String getName() {
        return this.name;
    }

    public String getStyleClassifier() {
        return this.styleClassifier;
    }

    public List<NomnomlField> getFields() {
        return this.fields;
    }

    public List<NomnomlMethod> getMethods() {
        return this.methods;
    }

    public List<NomnomlStereotype> getStereotypes() {
        return this.stereotypes;
    }

    public boolean isShowFields() {
        return this.showFields;
    }

    public boolean isShowMethods() {
        return this.showMethods;
    }

    public boolean equals(Object o) {
        List<NomnomlStereotype> other$stereotypes;
        List<NomnomlMethod> other$methods;
        List<NomnomlField> other$fields;
        String other$styleClassifier;
        String other$name;
        Optional<String> other$comment;
        if (o == this) {
            return true;
        }
        if (!(o instanceof NomnomlClass)) {
            return false;
        }
        NomnomlClass other = (NomnomlClass)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<String> this$comment = this.getComment();
        if (!Objects.equals(this$comment, other$comment = other.getComment())) {
            return false;
        }
        String this$name = this.getName();
        if (!Objects.equals(this$name, other$name = other.getName())) {
            return false;
        }
        String this$styleClassifier = this.getStyleClassifier();
        if (!Objects.equals(this$styleClassifier, other$styleClassifier = other.getStyleClassifier())) {
            return false;
        }
        List<NomnomlField> this$fields = this.getFields();
        if (!Objects.equals(this$fields, other$fields = other.getFields())) {
            return false;
        }
        List<NomnomlMethod> this$methods = this.getMethods();
        if (!Objects.equals(this$methods, other$methods = other.getMethods())) {
            return false;
        }
        List<NomnomlStereotype> this$stereotypes = this.getStereotypes();
        if (!Objects.equals(this$stereotypes, other$stereotypes = other.getStereotypes())) {
            return false;
        }
        if (this.isShowFields() != other.isShowFields()) {
            return false;
        }
        return this.isShowMethods() == other.isShowMethods();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NomnomlClass;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : ((Object)$comment).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $styleClassifier = this.getStyleClassifier();
        result = result * 59 + ($styleClassifier == null ? 43 : $styleClassifier.hashCode());
        List<NomnomlField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        List<NomnomlMethod> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        List<NomnomlStereotype> $stereotypes = this.getStereotypes();
        result = result * 59 + ($stereotypes == null ? 43 : ((Object)$stereotypes).hashCode());
        result = result * 59 + (this.isShowFields() ? 79 : 97);
        result = result * 59 + (this.isShowMethods() ? 79 : 97);
        return result;
    }

    public static class NomnomlClassBuilder {
        private String name;
        private String comment;
        private String styleClassifier;
        private List<NomnomlField> fields;
        private List<NomnomlMethod> methods;
        private List<NomnomlStereotype> stereotypes;
        private boolean showFields;
        private boolean showMethods;

        NomnomlClassBuilder() {
        }

        public NomnomlClassBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NomnomlClassBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public NomnomlClassBuilder styleClassifier(String styleClassifier) {
            this.styleClassifier = styleClassifier;
            return this;
        }

        public NomnomlClassBuilder fields(List<NomnomlField> fields) {
            this.fields = fields;
            return this;
        }

        public NomnomlClassBuilder methods(List<NomnomlMethod> methods) {
            this.methods = methods;
            return this;
        }

        public NomnomlClassBuilder stereotypes(List<NomnomlStereotype> stereotypes) {
            this.stereotypes = stereotypes;
            return this;
        }

        public NomnomlClassBuilder showFields(boolean showFields) {
            this.showFields = showFields;
            return this;
        }

        public NomnomlClassBuilder showMethods(boolean showMethods) {
            this.showMethods = showMethods;
            return this;
        }

        public NomnomlClass build() {
            return new NomnomlClass(this.name, this.comment, this.styleClassifier, this.fields, this.methods, this.stereotypes, this.showFields, this.showMethods);
        }

        public String toString() {
            return "NomnomlClass.NomnomlClassBuilder(name=" + this.name + ", comment=" + this.comment + ", styleClassifier=" + this.styleClassifier + ", fields=" + String.valueOf(this.fields) + ", methods=" + String.valueOf(this.methods) + ", stereotypes=" + String.valueOf(this.stereotypes) + ", showFields=" + this.showFields + ", showMethods=" + this.showMethods + ")";
        }
    }
}

