/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.nomnoml;

import io.domainlifecycles.diagram.Diagram;
import io.domainlifecycles.diagram.DiagramElement;
import java.util.List;
import java.util.Objects;

public class NomnomlDiagram
implements Diagram {
    private final List<String> styleDeclarations;
    private final List<DiagramElement> diagramElements;

    public NomnomlDiagram(List<String> styleDeclarations, List<DiagramElement> diagramElements) {
        this.styleDeclarations = Objects.requireNonNull(styleDeclarations);
        this.diagramElements = Objects.requireNonNull(diagramElements);
    }

    public static NomnomlDiagramBuilder builder() {
        return new NomnomlDiagramBuilder();
    }

    @Override
    public String generateDiagramText() {
        StringBuilder builder = new StringBuilder();
        this.styleDeclarations.forEach(s -> builder.append((String)s).append(System.lineSeparator()));
        this.diagramElements.forEach(e -> builder.append(e.getDiagramText()).append(System.lineSeparator()).append(System.lineSeparator()));
        return builder.toString();
    }

    public List<String> getStyleDeclarations() {
        return this.styleDeclarations;
    }

    public List<DiagramElement> getDiagramElements() {
        return this.diagramElements;
    }

    public boolean equals(Object o) {
        List<DiagramElement> other$diagramElements;
        List<String> other$styleDeclarations;
        if (o == this) {
            return true;
        }
        if (!(o instanceof NomnomlDiagram)) {
            return false;
        }
        NomnomlDiagram other = (NomnomlDiagram)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$styleDeclarations = this.getStyleDeclarations();
        if (!Objects.equals(this$styleDeclarations, other$styleDeclarations = other.getStyleDeclarations())) {
            return false;
        }
        List<DiagramElement> this$diagramElements = this.getDiagramElements();
        return Objects.equals(this$diagramElements, other$diagramElements = other.getDiagramElements());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NomnomlDiagram;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $styleDeclarations = this.getStyleDeclarations();
        result = result * 59 + ($styleDeclarations == null ? 43 : ((Object)$styleDeclarations).hashCode());
        List<DiagramElement> $diagramElements = this.getDiagramElements();
        result = result * 59 + ($diagramElements == null ? 43 : ((Object)$diagramElements).hashCode());
        return result;
    }

    public static class NomnomlDiagramBuilder {
        private List<String> styleDeclarations;
        private List<DiagramElement> diagramElements;

        NomnomlDiagramBuilder() {
        }

        public NomnomlDiagramBuilder styleDeclarations(List<String> styleDeclarations) {
            this.styleDeclarations = styleDeclarations;
            return this;
        }

        public NomnomlDiagramBuilder diagramElements(List<DiagramElement> diagramElements) {
            this.diagramElements = diagramElements;
            return this;
        }

        public NomnomlDiagram build() {
            return new NomnomlDiagram(this.styleDeclarations, this.diagramElements);
        }

        public String toString() {
            return "NomnomlDiagram.NomnomlDiagramBuilder(styleDeclarations=" + String.valueOf(this.styleDeclarations) + ", diagramElements=" + String.valueOf(this.diagramElements) + ")";
        }
    }
}

