/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.nomnoml;

import io.domainlifecycles.diagram.DiagramElement;
import io.domainlifecycles.diagram.nomnoml.NomnomlType;
import java.util.Objects;
import java.util.Optional;

public class NomnomlField
implements DiagramElement {
    private final String visibility;
    private final String name;
    private final Optional<String> typePrefix;
    private final NomnomlType type;
    private final boolean required;

    public NomnomlField(String visibility, String name, Optional<String> typePrefix, NomnomlType type, boolean required) {
        this.visibility = Objects.requireNonNull(visibility);
        this.name = Objects.requireNonNull(name);
        this.typePrefix = Objects.requireNonNull(typePrefix);
        this.type = Objects.requireNonNull(type);
        this.required = required;
    }

    public static NomnomlFieldBuilder builder() {
        return new NomnomlFieldBuilder();
    }

    @Override
    public String getDiagramText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.required ? "\\# " : "o ");
        builder.append(this.visibility);
        builder.append(" ");
        builder.append(this.name);
        builder.append(":");
        this.typePrefix.ifPresent(s -> builder.append((String)s).append(" "));
        builder.append(this.type.getDiagramText());
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    public String getVisibility() {
        return this.visibility;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getTypePrefix() {
        return this.typePrefix;
    }

    public NomnomlType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean equals(Object o) {
        NomnomlType other$type;
        Optional<String> other$typePrefix;
        String other$name;
        String other$visibility;
        if (o == this) {
            return true;
        }
        if (!(o instanceof NomnomlField)) {
            return false;
        }
        NomnomlField other = (NomnomlField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$visibility = this.getVisibility();
        if (!Objects.equals(this$visibility, other$visibility = other.getVisibility())) {
            return false;
        }
        String this$name = this.getName();
        if (!Objects.equals(this$name, other$name = other.getName())) {
            return false;
        }
        Optional<String> this$typePrefix = this.getTypePrefix();
        if (!Objects.equals(this$typePrefix, other$typePrefix = other.getTypePrefix())) {
            return false;
        }
        NomnomlType this$type = this.getType();
        if (!Objects.equals(this$type, other$type = other.getType())) {
            return false;
        }
        return this.isRequired() == other.isRequired();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NomnomlField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $typePrefix = this.getTypePrefix();
        result = result * 59 + ($typePrefix == null ? 43 : ((Object)$typePrefix).hashCode());
        NomnomlType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        result = result * 59 + (this.isRequired() ? 79 : 97);
        return result;
    }

    public static class NomnomlFieldBuilder {
        private String visibility;
        private String name;
        private Optional<String> typePrefix;
        private NomnomlType type;
        private boolean required;

        NomnomlFieldBuilder() {
        }

        public NomnomlFieldBuilder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public NomnomlFieldBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NomnomlFieldBuilder typePrefix(Optional<String> typePrefix) {
            this.typePrefix = typePrefix;
            return this;
        }

        public NomnomlFieldBuilder type(NomnomlType type) {
            this.type = type;
            return this;
        }

        public NomnomlFieldBuilder required(boolean required) {
            this.required = required;
            return this;
        }

        public NomnomlField build() {
            return new NomnomlField(this.visibility, this.name, this.typePrefix, this.type, this.required);
        }

        public String toString() {
            return "NomnomlField.NomnomlFieldBuilder(visibility=" + this.visibility + ", name=" + this.name + ", typePrefix=" + String.valueOf(this.typePrefix) + ", type=" + String.valueOf(this.type) + ", required=" + this.required + ")";
        }
    }
}

