/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.nomnoml;

import io.domainlifecycles.diagram.DiagramElement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NomnomlFrame
implements DiagramElement {
    private final String name;
    private final Optional<String> comment;
    private final String type;
    private final String styleClassifier;
    private final List<DiagramElement> innerElements;

    public NomnomlFrame(String name, String comment, String type, String styleClassifier, List<DiagramElement> innerElements) {
        this.name = Objects.requireNonNull(name);
        this.comment = Optional.ofNullable(comment);
        this.type = Objects.requireNonNull(type);
        this.styleClassifier = Objects.requireNonNull(styleClassifier);
        this.innerElements = Objects.requireNonNull(innerElements);
    }

    public static NomnomlFrameBuilder builder() {
        return new NomnomlFrameBuilder();
    }

    @Override
    public String getDiagramText() {
        StringBuilder builder = new StringBuilder();
        this.comment.ifPresent(s -> builder.append("// ").append((String)s).append(System.lineSeparator()));
        builder.append("[<");
        builder.append(this.styleClassifier);
        builder.append("> ");
        builder.append(this.name);
        builder.append(" ");
        builder.append(this.type);
        builder.append("|");
        builder.append(System.lineSeparator());
        this.innerElements.forEach(ie -> builder.append(ie.getDiagramText()));
        builder.append("]");
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public String getType() {
        return this.type;
    }

    public String getStyleClassifier() {
        return this.styleClassifier;
    }

    public List<DiagramElement> getInnerElements() {
        return this.innerElements;
    }

    public boolean equals(Object o) {
        List<DiagramElement> other$innerElements;
        String other$styleClassifier;
        String other$type;
        Optional<String> other$comment;
        String other$name;
        if (o == this) {
            return true;
        }
        if (!(o instanceof NomnomlFrame)) {
            return false;
        }
        NomnomlFrame other = (NomnomlFrame)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        if (!Objects.equals(this$name, other$name = other.getName())) {
            return false;
        }
        Optional<String> this$comment = this.getComment();
        if (!Objects.equals(this$comment, other$comment = other.getComment())) {
            return false;
        }
        String this$type = this.getType();
        if (!Objects.equals(this$type, other$type = other.getType())) {
            return false;
        }
        String this$styleClassifier = this.getStyleClassifier();
        if (!Objects.equals(this$styleClassifier, other$styleClassifier = other.getStyleClassifier())) {
            return false;
        }
        List<DiagramElement> this$innerElements = this.getInnerElements();
        return Objects.equals(this$innerElements, other$innerElements = other.getInnerElements());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NomnomlFrame;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<String> $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : ((Object)$comment).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $styleClassifier = this.getStyleClassifier();
        result = result * 59 + ($styleClassifier == null ? 43 : $styleClassifier.hashCode());
        List<DiagramElement> $innerElements = this.getInnerElements();
        result = result * 59 + ($innerElements == null ? 43 : ((Object)$innerElements).hashCode());
        return result;
    }

    public static class NomnomlFrameBuilder {
        private String name;
        private String comment;
        private String type;
        private String styleClassifier;
        private List<DiagramElement> innerElements;

        NomnomlFrameBuilder() {
        }

        public NomnomlFrameBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NomnomlFrameBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public NomnomlFrameBuilder type(String type) {
            this.type = type;
            return this;
        }

        public NomnomlFrameBuilder styleClassifier(String styleClassifier) {
            this.styleClassifier = styleClassifier;
            return this;
        }

        public NomnomlFrameBuilder innerElements(List<DiagramElement> innerElements) {
            this.innerElements = innerElements;
            return this;
        }

        public NomnomlFrame build() {
            return new NomnomlFrame(this.name, this.comment, this.type, this.styleClassifier, this.innerElements);
        }

        public String toString() {
            return "NomnomlFrame.NomnomlFrameBuilder(name=" + this.name + ", comment=" + this.comment + ", type=" + this.type + ", styleClassifier=" + this.styleClassifier + ", innerElements=" + String.valueOf(this.innerElements) + ")";
        }
    }
}

