/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.nomnoml;

import io.domainlifecycles.diagram.DiagramElement;
import io.domainlifecycles.diagram.nomnoml.NomnomlParameter;
import io.domainlifecycles.diagram.nomnoml.NomnomlType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class NomnomlMethod
implements DiagramElement {
    private final String visibility;
    private final String name;
    private final NomnomlType returnType;
    private final List<NomnomlParameter> parameters;

    public NomnomlMethod(String visibility, String name, NomnomlType returnType, List<NomnomlParameter> parameters) {
        this.visibility = Objects.requireNonNull(visibility);
        this.name = Objects.requireNonNull(name);
        this.returnType = Objects.requireNonNull(returnType);
        this.parameters = Objects.requireNonNull(parameters);
    }

    public static NomnomlMethodBuilder builder() {
        return new NomnomlMethodBuilder();
    }

    @Override
    public String getDiagramText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.visibility);
        builder.append(" ");
        builder.append(this.returnType.getDiagramText());
        builder.append(" ");
        builder.append(this.name);
        builder.append("(");
        this.addParameters(builder);
        builder.append(")");
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    private void addParameters(StringBuilder builder) {
        builder.append(this.parameters.stream().map(NomnomlParameter::getDiagramText).collect(Collectors.joining(",")));
    }

    public String getVisibility() {
        return this.visibility;
    }

    public String getName() {
        return this.name;
    }

    public NomnomlType getReturnType() {
        return this.returnType;
    }

    public List<NomnomlParameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        List<NomnomlParameter> other$parameters;
        NomnomlType other$returnType;
        String other$name;
        String other$visibility;
        if (o == this) {
            return true;
        }
        if (!(o instanceof NomnomlMethod)) {
            return false;
        }
        NomnomlMethod other = (NomnomlMethod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$visibility = this.getVisibility();
        if (!Objects.equals(this$visibility, other$visibility = other.getVisibility())) {
            return false;
        }
        String this$name = this.getName();
        if (!Objects.equals(this$name, other$name = other.getName())) {
            return false;
        }
        NomnomlType this$returnType = this.getReturnType();
        if (!Objects.equals(this$returnType, other$returnType = other.getReturnType())) {
            return false;
        }
        List<NomnomlParameter> this$parameters = this.getParameters();
        return Objects.equals(this$parameters, other$parameters = other.getParameters());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NomnomlMethod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NomnomlType $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : ((Object)$returnType).hashCode());
        List<NomnomlParameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public static class NomnomlMethodBuilder {
        private String visibility;
        private String name;
        private NomnomlType returnType;
        private List<NomnomlParameter> parameters;

        NomnomlMethodBuilder() {
        }

        public NomnomlMethodBuilder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public NomnomlMethodBuilder name(String name) {
            this.name = name;
            return this;
        }

        public NomnomlMethodBuilder returnType(NomnomlType returnType) {
            this.returnType = returnType;
            return this;
        }

        public NomnomlMethodBuilder parameters(List<NomnomlParameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public NomnomlMethod build() {
            return new NomnomlMethod(this.visibility, this.name, this.returnType, this.parameters);
        }

        public String toString() {
            return "NomnomlMethod.NomnomlMethodBuilder(visibility=" + this.visibility + ", name=" + this.name + ", returnType=" + String.valueOf(this.returnType) + ", parameters=" + String.valueOf(this.parameters) + ")";
        }
    }
}

