/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.nomnoml;

import io.domainlifecycles.diagram.DiagramElement;
import io.domainlifecycles.diagram.nomnoml.NomnomlType;
import java.util.Objects;

public class NomnomlParameter
implements DiagramElement {
    private final NomnomlType type;
    private final boolean required;

    public NomnomlParameter(NomnomlType type, boolean required) {
        this.type = Objects.requireNonNull(type);
        this.required = required;
    }

    public static NomnomlParameterBuilder builder() {
        return new NomnomlParameterBuilder();
    }

    @Override
    public String getDiagramText() {
        return (this.required ? "\\# " : "") + this.type.getDiagramText();
    }

    public NomnomlType getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean equals(Object o) {
        NomnomlType other$type;
        if (o == this) {
            return true;
        }
        if (!(o instanceof NomnomlParameter)) {
            return false;
        }
        NomnomlParameter other = (NomnomlParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NomnomlType this$type = this.getType();
        if (!Objects.equals(this$type, other$type = other.getType())) {
            return false;
        }
        return this.isRequired() == other.isRequired();
    }

    protected boolean canEqual(Object other) {
        return other instanceof NomnomlParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NomnomlType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        result = result * 59 + (this.isRequired() ? 79 : 97);
        return result;
    }

    public static class NomnomlParameterBuilder {
        private NomnomlType type;
        private boolean required;

        NomnomlParameterBuilder() {
        }

        public NomnomlParameterBuilder type(NomnomlType type) {
            this.type = type;
            return this;
        }

        public NomnomlParameterBuilder required(boolean required) {
            this.required = required;
            return this;
        }

        public NomnomlParameter build() {
            return new NomnomlParameter(this.type, this.required);
        }

        public String toString() {
            return "NomnomlParameter.NomnomlParameterBuilder(type=" + String.valueOf(this.type) + ", required=" + this.required + ")";
        }
    }
}

