/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.nomnoml;

import io.domainlifecycles.diagram.DiagramElement;
import java.util.Objects;

public class NomnomlRelationship
implements DiagramElement {
    private final String fromName;
    private final String fromStyleClassifier;
    private final String fromMultiplicity;
    private final String toName;
    private final String toStyleClassifier;
    private final String toMultiplicity;
    private final String label;
    private final RelationshipType relationshiptype;
    private boolean transposed;

    public NomnomlRelationship(String fromName, String fromStyleClassifier, String fromMultiplicity, String toName, String toStyleClassifier, String toMultiplicity, String label, RelationshipType relationshiptype) {
        this.fromName = Objects.requireNonNull(fromName);
        this.fromStyleClassifier = Objects.requireNonNull(fromStyleClassifier);
        this.fromMultiplicity = Objects.requireNonNull(fromMultiplicity);
        this.toName = Objects.requireNonNull(toName);
        this.toStyleClassifier = Objects.requireNonNull(toStyleClassifier);
        this.toMultiplicity = Objects.requireNonNull(toMultiplicity);
        this.label = Objects.requireNonNull(label);
        this.relationshiptype = Objects.requireNonNull(relationshiptype);
    }

    public static NomnomlRelationshipBuilder builder() {
        return new NomnomlRelationshipBuilder();
    }

    @Override
    public String getDiagramText() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (!this.transposed) {
            builder.append(this.fromStyleClassifier);
            builder.append(this.fromName);
        } else {
            builder.append(this.toStyleClassifier);
            builder.append(this.toName);
        }
        builder.append("] ");
        if (!this.transposed) {
            builder.append(this.fromMultiplicity);
        } else {
            builder.append(this.toMultiplicity);
        }
        builder.append(" ");
        if (!this.transposed) {
            builder.append(this.relationshiptype.lineStart);
        } else {
            builder.append(this.relationshiptype.transposedLineStart);
        }
        if (!this.label.isEmpty()) {
            builder.append("[<label> ");
            builder.append(this.label);
            builder.append("] ");
        }
        if (!this.transposed) {
            builder.append(this.relationshiptype.lineEnd);
            builder.append(this.toMultiplicity);
        } else {
            builder.append(this.relationshiptype.transposedLineEnd);
            builder.append(this.fromMultiplicity);
        }
        builder.append(" ");
        builder.append("[");
        if (!this.transposed) {
            builder.append(this.toStyleClassifier);
            builder.append(this.toName);
        } else {
            builder.append(this.fromStyleClassifier);
            builder.append(this.fromName);
        }
        builder.append("]");
        builder.append(System.lineSeparator());
        return builder.toString();
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getFromStyleClassifier() {
        return this.fromStyleClassifier;
    }

    public String getFromMultiplicity() {
        return this.fromMultiplicity;
    }

    public String getToName() {
        return this.toName;
    }

    public String getToStyleClassifier() {
        return this.toStyleClassifier;
    }

    public String getToMultiplicity() {
        return this.toMultiplicity;
    }

    public String getLabel() {
        return this.label;
    }

    public RelationshipType getRelationshiptype() {
        return this.relationshiptype;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public void transpose() {
        this.transposed = !this.transposed;
    }

    public static enum RelationshipType {
        INHERITANCE("<:", "-", "-", ":>"),
        REALIZATION("--", ":>", "<:", "--"),
        COMPOSITION("+-", "-", "-", "-+"),
        AGGREGATION("o-", "-", "-", "-o"),
        ASSOCIATION("-", "-", "-", "-"),
        DIRECTED_ASSOCIATION("-", "->", "<-", "-");

        private final String lineStart;
        private final String lineEnd;
        private final String transposedLineStart;
        private final String transposedLineEnd;

        private RelationshipType(String lineStart, String lineEnd, String transposedLineStart, String transposedLineEnd) {
            this.lineStart = lineStart;
            this.lineEnd = lineEnd;
            this.transposedLineStart = transposedLineStart;
            this.transposedLineEnd = transposedLineEnd;
        }
    }

    public static class NomnomlRelationshipBuilder {
        private String fromName;
        private String fromStyleClassifier;
        private String fromMultiplicity;
        private String toName;
        private String toStyleClassifier;
        private String toMultiplicity;
        private String label;
        private RelationshipType relationshiptype;

        NomnomlRelationshipBuilder() {
        }

        public NomnomlRelationshipBuilder fromName(String fromName) {
            this.fromName = fromName;
            return this;
        }

        public NomnomlRelationshipBuilder fromStyleClassifier(String fromStyleClassifier) {
            this.fromStyleClassifier = fromStyleClassifier;
            return this;
        }

        public NomnomlRelationshipBuilder fromMultiplicity(String fromMultiplicity) {
            this.fromMultiplicity = fromMultiplicity;
            return this;
        }

        public NomnomlRelationshipBuilder toName(String toName) {
            this.toName = toName;
            return this;
        }

        public NomnomlRelationshipBuilder toStyleClassifier(String toStyleClassifier) {
            this.toStyleClassifier = toStyleClassifier;
            return this;
        }

        public NomnomlRelationshipBuilder toMultiplicity(String toMultiplicity) {
            this.toMultiplicity = toMultiplicity;
            return this;
        }

        public NomnomlRelationshipBuilder label(String label) {
            this.label = label;
            return this;
        }

        public NomnomlRelationshipBuilder relationshiptype(RelationshipType relationshiptype) {
            this.relationshiptype = relationshiptype;
            return this;
        }

        public NomnomlRelationship build() {
            return new NomnomlRelationship(this.fromName, this.fromStyleClassifier, this.fromMultiplicity, this.toName, this.toStyleClassifier, this.toMultiplicity, this.label, this.relationshiptype);
        }

        public String toString() {
            return "NomnomlRelationship.NomnomlRelationshipBuilder(fromName=" + this.fromName + ", fromStyleClassifier=" + this.fromStyleClassifier + ", fromMultiplicity=" + this.fromMultiplicity + ", toName=" + this.toName + ", toStyleClassifier=" + this.toStyleClassifier + ", toMultiplicity=" + this.toMultiplicity + ", label=" + this.label + ", relationshiptype=" + String.valueOf((Object)this.relationshiptype) + ")";
        }
    }
}

