/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.nomnoml;

import io.domainlifecycles.diagram.DiagramElement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NomnomlType
implements DiagramElement {
    private final String typeName;
    private final List<String> typeAssertions;
    private final Optional<String> containerTypeName;
    private final List<String> containerTypeAssertions;

    public NomnomlType(String typeName, List<String> typeAssertions, Optional<String> containerTypeName, List<String> containerTypeAssertions) {
        this.typeName = Objects.requireNonNull(typeName);
        this.typeAssertions = Objects.requireNonNull(typeAssertions);
        this.containerTypeName = Objects.requireNonNull(containerTypeName);
        this.containerTypeAssertions = Objects.requireNonNull(containerTypeAssertions);
    }

    public static NomnomlTypeBuilder builder() {
        return new NomnomlTypeBuilder();
    }

    @Override
    public String getDiagramText() {
        StringBuilder builder = new StringBuilder();
        if (this.containerTypeName.isPresent()) {
            builder.append(this.containerTypeName.get());
            builder.append("<");
            builder.append(this.typeName.replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]"));
            this.addTypeAssertions(builder);
            builder.append(">");
            this.addContainerTypeAssertions(builder);
        } else {
            builder.append(this.typeName.replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]"));
            this.addTypeAssertions(builder);
        }
        return builder.toString();
    }

    private void addTypeAssertions(StringBuilder builder) {
        for (String assertion : this.typeAssertions) {
            builder.append(assertion);
        }
    }

    private void addContainerTypeAssertions(StringBuilder builder) {
        for (String assertion : this.containerTypeAssertions) {
            builder.append(assertion);
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<String> getTypeAssertions() {
        return this.typeAssertions;
    }

    public Optional<String> getContainerTypeName() {
        return this.containerTypeName;
    }

    public List<String> getContainerTypeAssertions() {
        return this.containerTypeAssertions;
    }

    public boolean equals(Object o) {
        List<String> other$containerTypeAssertions;
        Optional<String> other$containerTypeName;
        List<String> other$typeAssertions;
        String other$typeName;
        if (o == this) {
            return true;
        }
        if (!(o instanceof NomnomlType)) {
            return false;
        }
        NomnomlType other = (NomnomlType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        if (!Objects.equals(this$typeName, other$typeName = other.getTypeName())) {
            return false;
        }
        List<String> this$typeAssertions = this.getTypeAssertions();
        if (!Objects.equals(this$typeAssertions, other$typeAssertions = other.getTypeAssertions())) {
            return false;
        }
        Optional<String> this$containerTypeName = this.getContainerTypeName();
        if (!Objects.equals(this$containerTypeName, other$containerTypeName = other.getContainerTypeName())) {
            return false;
        }
        List<String> this$containerTypeAssertions = this.getContainerTypeAssertions();
        return Objects.equals(this$containerTypeAssertions, other$containerTypeAssertions = other.getContainerTypeAssertions());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NomnomlType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        List<String> $typeAssertions = this.getTypeAssertions();
        result = result * 59 + ($typeAssertions == null ? 43 : ((Object)$typeAssertions).hashCode());
        Optional<String> $containerTypeName = this.getContainerTypeName();
        result = result * 59 + ($containerTypeName == null ? 43 : ((Object)$containerTypeName).hashCode());
        List<String> $containerTypeAssertions = this.getContainerTypeAssertions();
        result = result * 59 + ($containerTypeAssertions == null ? 43 : ((Object)$containerTypeAssertions).hashCode());
        return result;
    }

    public static class NomnomlTypeBuilder {
        private String typeName;
        private List<String> typeAssertions;
        private Optional<String> containerTypeName;
        private List<String> containerTypeAssertions;

        NomnomlTypeBuilder() {
        }

        public NomnomlTypeBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public NomnomlTypeBuilder typeAssertions(List<String> typeAssertions) {
            this.typeAssertions = typeAssertions;
            return this;
        }

        public NomnomlTypeBuilder containerTypeName(Optional<String> containerTypeName) {
            this.containerTypeName = containerTypeName;
            return this;
        }

        public NomnomlTypeBuilder containerTypeAssertions(List<String> containerTypeAssertions) {
            this.containerTypeAssertions = containerTypeAssertions;
            return this;
        }

        public NomnomlType build() {
            return new NomnomlType(this.typeName, this.typeAssertions, this.containerTypeName, this.containerTypeAssertions);
        }

        public String toString() {
            return "NomnomlType.NomnomlTypeBuilder(typeName=" + this.typeName + ", typeAssertions=" + String.valueOf(this.typeAssertions) + ", containerTypeName=" + String.valueOf(this.containerTypeName) + ", containerTypeAssertions=" + String.valueOf(this.containerTypeAssertions) + ")";
        }
    }
}

