/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.api;

import io.domainlifecycles.domain.types.AggregateRoot;
import io.domainlifecycles.domain.types.ApplicationService;
import io.domainlifecycles.domain.types.DomainEvent;
import io.domainlifecycles.domain.types.DomainService;
import io.domainlifecycles.domain.types.Entity;
import io.domainlifecycles.domain.types.Identity;
import io.domainlifecycles.domain.types.OutboundService;
import io.domainlifecycles.domain.types.QueryHandler;
import io.domainlifecycles.domain.types.Repository;
import io.domainlifecycles.domain.types.ServiceKind;
import io.domainlifecycles.domain.types.ValueObject;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.ApplicationServiceMirror;
import io.domainlifecycles.mirror.api.BoundedContextMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainMirrorFactory;
import io.domainlifecycles.mirror.api.DomainServiceMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityMirror;
import io.domainlifecycles.mirror.api.IdentityMirror;
import io.domainlifecycles.mirror.api.OutboundServiceMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import io.domainlifecycles.mirror.api.ValueObjectMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import java.util.List;
import java.util.Optional;

public class Domain {
    private static boolean initialized = false;
    private static DomainMirror domainMirror;

    public static <V extends DomainTypeMirror> Optional<V> typeMirror(String fullQualifiedTypeName) {
        if (!initialized) {
            throw MirrorException.fail("Domain was not initialized!");
        }
        return domainMirror.getDomainTypeMirror(fullQualifiedTypeName);
    }

    public static <A extends AggregateRootMirror> A aggregateRootMirrorFor(AggregateRoot<?> aggregateRoot) {
        return (A)((AggregateRootMirror)Domain.typeMirror(aggregateRoot.getClass().getName()).orElseThrow(() -> MirrorException.fail("No AggregateRootMirror found for %s", aggregateRoot.getClass().getName())));
    }

    public static <A extends AggregateRootMirror> A aggregateRootMirrorFor(String aggregateRootTypeName) {
        return (A)((AggregateRootMirror)Domain.typeMirror(aggregateRootTypeName).orElseThrow(() -> MirrorException.fail("No AggregateRootMirror found for %s", aggregateRootTypeName)));
    }

    public static <E extends EntityMirror> E entityMirrorFor(String entityTypeName) {
        return (E)((EntityMirror)Domain.typeMirror(entityTypeName).orElseThrow(() -> MirrorException.fail("No EntityMirror found for %s", entityTypeName)));
    }

    public static <E extends EntityMirror> E entityMirrorFor(Entity<?> entity) {
        return (E)((EntityMirror)Domain.typeMirror(entity.getClass().getName()).orElseThrow(() -> MirrorException.fail("No EntityMirror found for %s", entity.getClass().getName())));
    }

    public static <E extends EntityMirror> E entityMirrorForIdentityTypeName(String identityTypeName) {
        if (!initialized) {
            throw MirrorException.fail("Domain was not initialized!");
        }
        return (E)((EntityMirror)domainMirror.getAllDomainTypeMirrors().stream().filter(dm -> {
            EntityMirror em;
            if (dm instanceof EntityMirror && (em = (EntityMirror)dm).getIdentityField().isPresent()) {
                return em.getIdentityField().get().getType().getTypeName().equals(identityTypeName);
            }
            return false;
        }).findFirst().orElseThrow(() -> MirrorException.fail("No EntityMirror found for identity type %s", identityTypeName)));
    }

    public static <DE extends DomainEventMirror> DE domainEventMirrorFor(DomainEvent domainEvent) {
        return (DE)((DomainEventMirror)Domain.typeMirror(domainEvent.getClass().getName()).orElseThrow(() -> MirrorException.fail("No DomainEventMirror found for %s", domainEvent.getClass().getName())));
    }

    public static <DE extends DomainEventMirror> DE domainEventMirrorFor(String domainEventTypeName) {
        return (DE)((DomainEventMirror)Domain.typeMirror(domainEventTypeName).orElseThrow(() -> MirrorException.fail("No DomainEventMirror found for %s", domainEventTypeName)));
    }

    public static <DS extends DomainServiceMirror> DS domainServiceMirrorFor(DomainService domainService) {
        return (DS)((DomainServiceMirror)Domain.typeMirror(domainService.getClass().getName()).orElseThrow(() -> MirrorException.fail("No DomainServiceMirror found for %s", domainService.getClass().getName())));
    }

    public static <DS extends DomainServiceMirror> DS domainServiceMirrorFor(String domainServiceTypeName) {
        return (DS)((DomainServiceMirror)Domain.typeMirror(domainServiceTypeName).orElseThrow(() -> MirrorException.fail("No DomainServiceMirror found for %s", domainServiceTypeName)));
    }

    public static <AS extends ServiceKindMirror> AS serviceKindMirrorFor(ServiceKind serviceKind) {
        return (AS)((ServiceKindMirror)Domain.typeMirror(serviceKind.getClass().getName()).orElseThrow(() -> MirrorException.fail("No ServiceKindMirror found for %s", serviceKind.getClass().getName())));
    }

    public static <AS extends ServiceKindMirror> AS serviceKindMirrorFor(String serviceKindTypeName) {
        return (AS)((ServiceKindMirror)Domain.typeMirror(serviceKindTypeName).orElseThrow(() -> MirrorException.fail("No ServiceKindMirror found for %s", serviceKindTypeName)));
    }

    public static <AS extends ApplicationServiceMirror> AS applicationServiceMirrorFor(ApplicationService applicationService) {
        return (AS)((ApplicationServiceMirror)Domain.typeMirror(applicationService.getClass().getName()).orElseThrow(() -> MirrorException.fail("No ApplicationServiceMirror found for %s", applicationService.getClass().getName())));
    }

    public static <AS extends ApplicationServiceMirror> AS applicationServiceMirrorFor(String applicationServiceTypeName) {
        return (AS)((ApplicationServiceMirror)Domain.typeMirror(applicationServiceTypeName).orElseThrow(() -> MirrorException.fail("No ApplicationServiceMirror found for %s", applicationServiceTypeName)));
    }

    public static <R extends RepositoryMirror> R repositoryMirrorFor(AggregateRootMirror arm) {
        return (R)domainMirror.getAllDomainTypeMirrors().stream().filter(tm -> tm.getDomainType().equals((Object)DomainType.REPOSITORY)).map(tm -> (RepositoryMirror)tm).filter(rm -> rm.getManagedAggregate().isPresent() && rm.getManagedAggregate().get().equals(arm)).findFirst().orElseThrow(() -> MirrorException.fail("No RepositoryMirror found for AggregateRoot %s", arm.getTypeName()));
    }

    public static <R extends RepositoryMirror> R repositoryMirrorFor(Repository<?, ?> repository) {
        return (R)((RepositoryMirror)Domain.typeMirror(repository.getClass().getName()).orElseThrow(() -> MirrorException.fail("No RepositoryMirror found for %s", repository.getClass().getName())));
    }

    public static <R extends RepositoryMirror> R repositoryMirrorFor(String repositoryTypeName) {
        return (R)((RepositoryMirror)Domain.typeMirror(repositoryTypeName).orElseThrow(() -> MirrorException.fail("No RepositoryMirror found for %s", repositoryTypeName)));
    }

    public static <I extends IdentityMirror> I identityMirrorFor(String identityTypeName) {
        return (I)((IdentityMirror)Domain.typeMirror(identityTypeName).orElseThrow(() -> MirrorException.fail("No IdentityMirror found for %s", identityTypeName)));
    }

    public static <I extends IdentityMirror> I identityMirrorFor(Identity<?> identity) {
        return (I)((IdentityMirror)Domain.typeMirror(identity.getClass().getName()).orElseThrow(() -> MirrorException.fail("No IdentityMirror found for %s", identity.getClass().getName())));
    }

    public static <V extends ValueObjectMirror> V valueObjectMirrorFor(ValueObject valueObject) {
        return (V)((ValueObjectMirror)Domain.typeMirror(valueObject.getClass().getName()).orElseThrow(() -> MirrorException.fail("No ValueObjectMirror found for %s", valueObject.getClass().getName())));
    }

    public static <V extends ValueObjectMirror> V valueObjectMirrorFor(String valueObjectTypeName) {
        return (V)((ValueObjectMirror)Domain.typeMirror(valueObjectTypeName).orElseThrow(() -> MirrorException.fail("No ValueObjectMirror found for %s", valueObjectTypeName)));
    }

    public static <V extends OutboundServiceMirror> V outboundServiceMirrorFor(OutboundService outboundService) {
        return (V)((OutboundServiceMirror)Domain.typeMirror(outboundService.getClass().getName()).orElseThrow(() -> MirrorException.fail("No OutboundServiceMirror found for %s", outboundService.getClass().getName())));
    }

    public static <V extends OutboundServiceMirror> V outboundServiceMirrorFor(String outboundServiceTypeName) {
        return (V)((OutboundServiceMirror)Domain.typeMirror(outboundServiceTypeName).orElseThrow(() -> MirrorException.fail("No OutboundServiceMirror found for %s", outboundServiceTypeName)));
    }

    public static <V extends QueryHandlerMirror> V queryHandlerMirrorFor(QueryHandler<?> queryHandler) {
        return (V)((QueryHandlerMirror)Domain.typeMirror(queryHandler.getClass().getName()).orElseThrow(() -> MirrorException.fail("No QueryHandlerMirror found for %s", queryHandler.getClass().getName())));
    }

    public static <V extends QueryHandlerMirror> V queryHandlerMirrorFor(String queryHandlerTypeName) {
        return (V)((QueryHandlerMirror)Domain.typeMirror(queryHandlerTypeName).orElseThrow(() -> MirrorException.fail("No QueryHandlerMirror found for %s", queryHandlerTypeName)));
    }

    public static List<BoundedContextMirror> getBoundedContexts() {
        if (!initialized) {
            throw MirrorException.fail("Domain was not initialized!");
        }
        return domainMirror.getAllBoundedContextMirrors();
    }

    public static DomainMirror getDomainMirror() {
        return domainMirror;
    }

    public static void initialize(DomainMirrorFactory domainMirrorFactory) {
        domainMirror = domainMirrorFactory.initializeDomainMirror();
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized;
    }
}

