/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.api;

import io.domainlifecycles.domain.types.AggregateRoot;
import io.domainlifecycles.domain.types.ApplicationService;
import io.domainlifecycles.domain.types.DomainCommand;
import io.domainlifecycles.domain.types.DomainEvent;
import io.domainlifecycles.domain.types.DomainService;
import io.domainlifecycles.domain.types.Entity;
import io.domainlifecycles.domain.types.Identity;
import io.domainlifecycles.domain.types.OutboundService;
import io.domainlifecycles.domain.types.QueryHandler;
import io.domainlifecycles.domain.types.ReadModel;
import io.domainlifecycles.domain.types.Repository;
import io.domainlifecycles.domain.types.ServiceKind;
import io.domainlifecycles.domain.types.ValueObject;
import java.lang.reflect.Type;

public enum DomainType {
    AGGREGATE_ROOT,
    ENTITY,
    VALUE_OBJECT,
    IDENTITY,
    ENUM,
    DOMAIN_EVENT,
    DOMAIN_COMMAND,
    DOMAIN_SERVICE,
    REPOSITORY,
    READ_MODEL,
    APPLICATION_SERVICE,
    SERVICE_KIND,
    QUERY_HANDLER,
    OUTBOUND_SERVICE,
    NON_DOMAIN;


    public static DomainType of(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            if (AggregateRoot.class.isAssignableFrom(c)) {
                return AGGREGATE_ROOT;
            }
            if (Entity.class.isAssignableFrom(c)) {
                return ENTITY;
            }
            if (ValueObject.class.isAssignableFrom(c)) {
                return VALUE_OBJECT;
            }
            if (Enum.class.isAssignableFrom(c)) {
                return ENUM;
            }
            if (Identity.class.isAssignableFrom(c)) {
                return IDENTITY;
            }
            if (DomainService.class.isAssignableFrom(c)) {
                return DOMAIN_SERVICE;
            }
            if (Repository.class.isAssignableFrom(c)) {
                return REPOSITORY;
            }
            if (DomainEvent.class.isAssignableFrom(c)) {
                return DOMAIN_EVENT;
            }
            if (DomainCommand.class.isAssignableFrom(c)) {
                return DOMAIN_COMMAND;
            }
            if (ReadModel.class.isAssignableFrom(c)) {
                return READ_MODEL;
            }
            if (ApplicationService.class.isAssignableFrom(c)) {
                return APPLICATION_SERVICE;
            }
            if (QueryHandler.class.isAssignableFrom(c)) {
                return QUERY_HANDLER;
            }
            if (OutboundService.class.isAssignableFrom(c)) {
                return OUTBOUND_SERVICE;
            }
            if (ServiceKind.class.isAssignableFrom(c)) {
                return SERVICE_KIND;
            }
        }
        return NON_DOMAIN;
    }
}

