/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.AssertedContainableTypeMirror;
import io.domainlifecycles.mirror.api.AssertionMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.ResolvedGenericTypeMirror;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AssertedContainableTypeModel
implements AssertedContainableTypeMirror {
    private final String typeName;
    private final DomainType domainType;
    private final List<AssertionMirror> assertions;
    @JsonProperty
    private final boolean hasOptionalContainer;
    @JsonProperty
    private final boolean hasCollectionContainer;
    @JsonProperty
    private final boolean hasSetContainer;
    @JsonProperty
    private final boolean hasListContainer;
    @JsonProperty
    private final boolean isArray;
    @JsonProperty
    private final boolean hasStreamContainer;
    private final String containerTypeName;
    private final List<AssertionMirror> containerAssertions;
    private final ResolvedGenericTypeMirror resolvedGenericType;

    @JsonCreator
    public AssertedContainableTypeModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="domainType") DomainType domainType, @JsonProperty(value="assertions") List<AssertionMirror> assertions, @JsonProperty(value="hasOptionalContainer") boolean hasOptionalContainer, @JsonProperty(value="hasCollectionContainer") boolean hasCollectionContainer, @JsonProperty(value="hasListContainer") boolean hasListContainer, @JsonProperty(value="hasSetContainer") boolean hasSetContainer, @JsonProperty(value="hasStreamContainer") boolean hasStreamContainer, @JsonProperty(value="isArray") boolean isArray, @JsonProperty(value="containerTypeName") String containerTypeName, @JsonProperty(value="containerAssertions") List<AssertionMirror> containerAssertions, @JsonProperty(value="resolvedGenericType") ResolvedGenericTypeMirror resolvedGenericType) {
        this.typeName = Objects.requireNonNull(typeName);
        this.domainType = Objects.requireNonNull(domainType);
        Objects.requireNonNull(assertions);
        this.assertions = Collections.unmodifiableList(assertions);
        this.hasOptionalContainer = hasOptionalContainer;
        this.hasCollectionContainer = hasCollectionContainer;
        this.hasListContainer = hasListContainer;
        this.hasSetContainer = hasSetContainer;
        this.hasStreamContainer = hasStreamContainer;
        this.isArray = isArray;
        this.containerTypeName = containerTypeName;
        Objects.requireNonNull(containerAssertions);
        this.containerAssertions = Collections.unmodifiableList(containerAssertions);
        this.resolvedGenericType = resolvedGenericType;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public List<AssertionMirror> getAssertions() {
        return this.assertions;
    }

    @Override
    public DomainType getDomainType() {
        return this.domainType;
    }

    @Override
    public boolean hasOptionalContainer() {
        return this.hasOptionalContainer;
    }

    @Override
    public boolean hasCollectionContainer() {
        return this.hasCollectionContainer;
    }

    @Override
    public boolean hasListContainer() {
        return this.hasListContainer;
    }

    @Override
    public boolean hasSetContainer() {
        return this.hasSetContainer;
    }

    @Override
    public boolean hasStreamContainer() {
        return this.hasStreamContainer;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public Optional<String> getContainerTypeName() {
        return Optional.ofNullable(this.containerTypeName);
    }

    @Override
    public List<AssertionMirror> getContainerAssertions() {
        return this.containerAssertions;
    }

    @Override
    public ResolvedGenericTypeMirror getResolvedGenericType() {
        return this.resolvedGenericType;
    }

    public String toString() {
        return "AssertedContainableTypeModel{typeName='" + this.typeName + "', domainType=" + String.valueOf((Object)this.domainType) + ", assertions=" + String.valueOf(this.assertions) + ", hasOptionalContainer=" + this.hasOptionalContainer + ", hasCollectionContainer=" + this.hasCollectionContainer + ", hasListContainer=" + this.hasListContainer + ", hasSetContainer=" + this.hasSetContainer + ", hasStreamContainer=" + this.hasStreamContainer + ", isArray=" + this.isArray + ", containerTypeName='" + this.containerTypeName + "', containerAssertions=" + String.valueOf(this.containerAssertions) + ", resolvedGenericType=" + String.valueOf(this.resolvedGenericType) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssertedContainableTypeModel that = (AssertedContainableTypeModel)o;
        return this.hasOptionalContainer == that.hasOptionalContainer && this.hasCollectionContainer == that.hasCollectionContainer && this.hasListContainer == that.hasListContainer && this.hasSetContainer == that.hasSetContainer && this.hasStreamContainer == that.hasStreamContainer && this.isArray == that.isArray && this.typeName.equals(that.typeName) && this.domainType == that.domainType && this.assertions.equals(that.assertions) && Objects.equals(this.containerTypeName, that.containerTypeName) && this.containerAssertions.equals(that.containerAssertions) && Objects.equals(this.resolvedGenericType, that.resolvedGenericType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeName, this.domainType, this.assertions, this.hasOptionalContainer, this.hasCollectionContainer, this.hasListContainer, this.hasSetContainer, this.hasStreamContainer, this.isArray, this.containerTypeName, this.containerAssertions, this.resolvedGenericType});
    }
}

