/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.ApplicationServiceMirror;
import io.domainlifecycles.mirror.api.BoundedContextMirror;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainServiceMirror;
import io.domainlifecycles.mirror.api.OutboundServiceMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.ReadModelMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import io.domainlifecycles.mirror.model.ProvidedDomain;
import java.util.List;
import java.util.Objects;

public class BoundedContextModel
implements BoundedContextMirror,
ProvidedDomain {
    private final String packageName;
    DomainMirror domainMirror;
    private boolean domainMirrorSet = false;

    @JsonCreator
    public BoundedContextModel(@JsonProperty(value="packageName") String packageName) {
        this.packageName = Objects.requireNonNull(packageName);
    }

    @Override
    @JsonIgnore
    public List<AggregateRootMirror> getAggregateRoots() {
        return this.domainMirror.getAllAggregateRootMirrors().stream().filter(dt -> dt.getTypeName().startsWith(this.packageName)).toList();
    }

    @Override
    @JsonIgnore
    public List<DomainServiceMirror> getDomainServices() {
        return this.domainMirror.getAllDomainServiceMirrors().stream().filter(dt -> dt.getTypeName().startsWith(this.packageName)).toList();
    }

    @Override
    @JsonIgnore
    public List<RepositoryMirror> getRepositories() {
        return this.domainMirror.getAllRepositoryMirrors().stream().filter(dt -> dt.getTypeName().startsWith(this.packageName)).toList();
    }

    @Override
    @JsonIgnore
    public List<ReadModelMirror> getReadModels() {
        return this.domainMirror.getAllReadModelMirrors().stream().filter(dt -> dt.getTypeName().startsWith(this.packageName)).toList();
    }

    @Override
    @JsonIgnore
    public List<DomainCommandMirror> getDomainCommands() {
        return this.domainMirror.getAllDomainCommandMirrors().stream().filter(dt -> dt.getTypeName().startsWith(this.packageName)).toList();
    }

    @Override
    @JsonIgnore
    public List<DomainEventMirror> getDomainEvents() {
        return this.domainMirror.getAllDomainEventMirrors().stream().filter(dt -> dt.getTypeName().startsWith(this.packageName)).toList();
    }

    @Override
    @JsonIgnore
    public List<ApplicationServiceMirror> getApplicationServices() {
        return this.domainMirror.getAllApplicationServiceMirrors().stream().filter(dt -> dt.getTypeName().startsWith(this.packageName)).toList();
    }

    @Override
    @JsonIgnore
    public List<QueryHandlerMirror> getQueryHandlers() {
        return this.domainMirror.getAllQueryHandlerMirrors().stream().filter(dt -> dt.getTypeName().startsWith(this.packageName)).toList();
    }

    @Override
    @JsonIgnore
    public List<OutboundServiceMirror> getOutboundServices() {
        return this.domainMirror.getAllOutboundServiceMirrors().stream().filter(dt -> dt.getTypeName().startsWith(this.packageName)).toList();
    }

    @Override
    @JsonIgnore
    public List<ServiceKindMirror> getServiceKinds() {
        return this.domainMirror.getAllServiceKindMirrors().stream().filter(dt -> dt.getTypeName().startsWith(this.packageName)).toList();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "BoundedContextModel{packageName='" + this.packageName + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundedContextModel that = (BoundedContextModel)o;
        return this.packageName.equals(that.packageName);
    }

    public int hashCode() {
        return Objects.hash(this.packageName);
    }

    @Override
    public void setDomainMirror(DomainMirror domainMirror) {
        if (!this.domainMirrorSet) {
            this.domainMirror = domainMirror;
            this.domainMirrorSet = true;
        }
    }

    @Override
    public boolean domainMirrorSet() {
        return this.domainMirrorSet;
    }
}

