/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.AggregateRootReferenceMirror;
import io.domainlifecycles.mirror.api.ApplicationServiceMirror;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.api.DomainServiceMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityReferenceMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.IdentityMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.OutboundServiceMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import io.domainlifecycles.mirror.api.ValueReferenceMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import io.domainlifecycles.mirror.model.DomainTypeModel;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class DomainCommandModel
extends DomainTypeModel
implements DomainCommandMirror {
    @JsonProperty
    private final Optional<String> aggregateTargetIdentityTypeName;
    @JsonProperty
    private final Optional<String> domainServiceTargetTypeName;

    @JsonCreator
    public DomainCommandModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="abstract") boolean isAbstract, @JsonProperty(value="allFields") List<FieldMirror> allFields, @JsonProperty(value="methods") List<MethodMirror> methods, @JsonProperty(value="aggregateTargetIdentityTypeName") Optional<String> aggregateTargetIdentityTypeName, @JsonProperty(value="domainServiceTargetTypeName") Optional<String> domainServiceTargetTypeName, @JsonProperty(value="inheritanceHierarchyTypeNames") List<String> inheritanceHierarchyTypeNames, @JsonProperty(value="allInterfaceTypeNames") List<String> allInterfaceTypeNames) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
        this.aggregateTargetIdentityTypeName = Objects.requireNonNull(aggregateTargetIdentityTypeName);
        this.domainServiceTargetTypeName = Objects.requireNonNull(domainServiceTargetTypeName);
    }

    @Override
    @JsonIgnore
    public List<FieldMirror> getBasicFields() {
        return this.allFields.stream().filter(p -> DomainType.NON_DOMAIN.equals((Object)p.getType().getDomainType())).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<ValueReferenceMirror> getValueReferences() {
        return this.allFields.stream().filter(p -> DomainType.VALUE_OBJECT.equals((Object)p.getType().getDomainType()) || DomainType.ENUM.equals((Object)p.getType().getDomainType()) || DomainType.IDENTITY.equals((Object)p.getType().getDomainType())).map(p -> (ValueReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<EntityReferenceMirror> getEntityReferences() {
        return this.allFields.stream().filter(p -> DomainType.ENTITY.equals((Object)p.getType().getDomainType())).map(p -> (EntityReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<AggregateRootReferenceMirror> getAggregateRootReferences() {
        return this.allFields.stream().filter(p -> DomainType.AGGREGATE_ROOT.equals((Object)p.getType().getDomainType())).map(p -> (AggregateRootReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public Optional<AggregateRootMirror> getAggregateTarget() {
        Optional<IdentityMirror> identity = this.aggregateTargetIdentityTypeName.map(n -> (DomainTypeMirror)this.domainMirror.getDomainTypeMirror((String)n).orElseThrow(() -> MirrorException.fail("AggregateRootMirror not found for '%s'", n))).map(m -> (IdentityMirror)m);
        return identity.flatMap(identityMirror -> this.domainMirror.getAllDomainTypeMirrors().stream().filter(tm -> tm instanceof AggregateRootMirror).map(tm -> (AggregateRootMirror)tm).filter(am -> am.getIdentityField().isPresent()).filter(am -> am.getIdentityField().get().getType().getTypeName().equals(identityMirror.getTypeName())).findFirst());
    }

    @Override
    @JsonIgnore
    public Optional<DomainServiceMirror> getDomainServiceTarget() {
        return this.domainServiceTargetTypeName.map(n -> (DomainTypeMirror)this.domainMirror.getDomainTypeMirror((String)n).orElseThrow(() -> MirrorException.fail("DomainServiceMirror not found for '%s'", n))).map(m -> (DomainServiceMirror)m);
    }

    @Override
    @JsonIgnore
    public List<ServiceKindMirror> getProcessingServiceKinds() {
        return this.domainMirror.getAllServiceKindMirrors().stream().filter(s -> s.processes(this)).toList();
    }

    @Override
    @JsonIgnore
    public List<ApplicationServiceMirror> getProcessingApplicationServices() {
        return this.domainMirror.getAllApplicationServiceMirrors().stream().filter(s -> s.processes(this)).toList();
    }

    @Override
    @JsonIgnore
    public List<DomainServiceMirror> getProcessingDomainServices() {
        return this.domainMirror.getAllDomainServiceMirrors().stream().filter(s -> s.processes(this)).toList();
    }

    @Override
    @JsonIgnore
    public List<RepositoryMirror> getProcessingRepositories() {
        return this.domainMirror.getAllRepositoryMirrors().stream().filter(s -> s.processes(this)).toList();
    }

    @Override
    @JsonIgnore
    public List<OutboundServiceMirror> getProcessingOutboundServices() {
        return this.domainMirror.getAllOutboundServiceMirrors().stream().filter(s -> s.processes(this)).toList();
    }

    @Override
    @JsonIgnore
    public List<QueryHandlerMirror> getProcessingQueryHandlers() {
        return this.domainMirror.getAllQueryHandlerMirrors().stream().filter(s -> s.processes(this)).toList();
    }

    @Override
    @JsonIgnore
    public DomainType getDomainType() {
        return DomainType.DOMAIN_COMMAND;
    }

    @Override
    public String toString() {
        return "DomainCommandModel{aggregateTargetIdentityTypeName=" + String.valueOf(this.aggregateTargetIdentityTypeName) + ", domainServiceTargetTypeName=" + String.valueOf(this.domainServiceTargetTypeName) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DomainCommandModel that = (DomainCommandModel)o;
        return this.aggregateTargetIdentityTypeName.equals(that.aggregateTargetIdentityTypeName) && this.domainServiceTargetTypeName.equals(that.domainServiceTargetTypeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.aggregateTargetIdentityTypeName, this.domainServiceTargetTypeName);
    }
}

