/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.AggregateRootReferenceMirror;
import io.domainlifecycles.mirror.api.ApplicationServiceMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainServiceMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.EntityReferenceMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.OutboundServiceMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import io.domainlifecycles.mirror.api.ValueReferenceMirror;
import io.domainlifecycles.mirror.model.DomainTypeModel;
import java.util.List;
import java.util.stream.Collectors;

public class DomainEventModel
extends DomainTypeModel
implements DomainEventMirror {
    @JsonCreator
    public DomainEventModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="abstract") boolean isAbstract, @JsonProperty(value="allFields") List<FieldMirror> allFields, @JsonProperty(value="methods") List<MethodMirror> methods, @JsonProperty(value="inheritanceHierarchyTypeNames") List<String> inheritanceHierarchyTypeNames, @JsonProperty(value="allInterfaceTypeNames") List<String> allInterfaceTypeNames) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
    }

    @Override
    @JsonIgnore
    public List<FieldMirror> getBasicFields() {
        return this.allFields.stream().filter(p -> DomainType.NON_DOMAIN.equals((Object)p.getType().getDomainType())).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<ValueReferenceMirror> getValueReferences() {
        return this.allFields.stream().filter(p -> DomainType.VALUE_OBJECT.equals((Object)p.getType().getDomainType()) || DomainType.ENUM.equals((Object)p.getType().getDomainType()) || DomainType.IDENTITY.equals((Object)p.getType().getDomainType())).map(p -> (ValueReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<EntityReferenceMirror> getEntityReferences() {
        return this.allFields.stream().filter(p -> DomainType.ENTITY.equals((Object)p.getType().getDomainType())).map(p -> (EntityReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<AggregateRootReferenceMirror> getAggregateRootReferences() {
        return this.allFields.stream().filter(p -> DomainType.AGGREGATE_ROOT.equals((Object)p.getType().getDomainType())).map(p -> (AggregateRootReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<AggregateRootMirror> getPublishingAggregates() {
        return this.domainMirror.getAllAggregateRootMirrors().stream().filter(a -> a.publishes(this) || a.getEntityReferences().stream().map(EntityReferenceMirror::getEntity).anyMatch(e -> e.publishes(this))).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<DomainServiceMirror> getPublishingDomainServices() {
        return this.domainMirror.getAllDomainServiceMirrors().stream().filter(ds -> ds.publishes(this)).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<RepositoryMirror> getPublishingRepositories() {
        return this.domainMirror.getAllRepositoryMirrors().stream().filter(r -> r.publishes(this)).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<AggregateRootMirror> getListeningAggregates() {
        return this.domainMirror.getAllAggregateRootMirrors().stream().filter(a -> a.listensTo(this) || a.getEntityReferences().stream().map(EntityReferenceMirror::getEntity).anyMatch(e -> e.listensTo(this))).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<DomainServiceMirror> getListeningDomainServices() {
        return this.domainMirror.getAllDomainServiceMirrors().stream().filter(ds -> ds.listensTo(this)).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<RepositoryMirror> getListeningRepositories() {
        return this.domainMirror.getAllRepositoryMirrors().stream().filter(r -> r.listensTo(this)).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<ApplicationServiceMirror> getListeningApplicationServices() {
        return this.domainMirror.getAllApplicationServiceMirrors().stream().filter(r -> r.listensTo(this)).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<OutboundServiceMirror> getListeningOutboundServices() {
        return this.domainMirror.getAllOutboundServiceMirrors().stream().filter(a -> a.listensTo(this)).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<QueryHandlerMirror> getListeningQueryHandlers() {
        return this.domainMirror.getAllQueryHandlerMirrors().stream().filter(a -> a.listensTo(this)).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<ServiceKindMirror> getListeningServiceKinds() {
        return this.domainMirror.getAllServiceKindMirrors().stream().filter(a -> a.listensTo(this)).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<ApplicationServiceMirror> getPublishingApplicationServices() {
        return this.domainMirror.getAllApplicationServiceMirrors().stream().filter(s -> s.publishes(this)).toList();
    }

    @Override
    @JsonIgnore
    public List<OutboundServiceMirror> getPublishingOutboundServices() {
        return this.domainMirror.getAllOutboundServiceMirrors().stream().filter(s -> s.publishes(this)).toList();
    }

    @Override
    @JsonIgnore
    public List<QueryHandlerMirror> getPublishingQueryHandlers() {
        return this.domainMirror.getAllQueryHandlerMirrors().stream().filter(s -> s.publishes(this)).toList();
    }

    @Override
    @JsonIgnore
    public List<ServiceKindMirror> getPublishingServiceKinds() {
        return this.domainMirror.getAllServiceKindMirrors().stream().filter(s -> s.publishes(this)).toList();
    }

    @Override
    @JsonIgnore
    public DomainType getDomainType() {
        return DomainType.DOMAIN_EVENT;
    }

    @Override
    public String toString() {
        return "DomainEventModel{} " + super.toString();
    }
}

