/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.ApplicationServiceMirror;
import io.domainlifecycles.mirror.api.BoundedContextMirror;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainServiceMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityMirror;
import io.domainlifecycles.mirror.api.EnumMirror;
import io.domainlifecycles.mirror.api.IdentityMirror;
import io.domainlifecycles.mirror.api.OutboundServiceMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.ReadModelMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import io.domainlifecycles.mirror.api.ValueMirror;
import io.domainlifecycles.mirror.api.ValueObjectMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import io.domainlifecycles.mirror.model.BoundedContextModel;
import io.domainlifecycles.mirror.model.DomainTypeModel;
import io.domainlifecycles.mirror.model.EntityModel;
import io.domainlifecycles.mirror.model.FieldModel;
import io.domainlifecycles.mirror.model.MethodModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DomainModel
implements DomainMirror {
    private final Map<String, ? extends DomainTypeMirror> allTypeMirrors;
    private final List<BoundedContextMirror> boundedContextMirrors;
    private static final Pattern packagePattern = Pattern.compile("^[a-z]+(\\.[a-zA-Z_][a-zA-Z0-9_]*)*$");

    public DomainModel(Map<String, ? extends DomainTypeMirror> allTypeMirrors, String ... boundedContextPackages) {
        this.allTypeMirrors = new HashMap<String, DomainTypeMirror>(allTypeMirrors);
        this.boundedContextMirrors = this.buildBoundedContextMirrors(boundedContextPackages);
        this.initDomainModelReferences();
    }

    private void initDomainModelReferences() {
        this.allTypeMirrors.values().stream().map(m -> (DomainTypeModel)m).forEach(m -> {
            m.setDomainMirror(this);
            if (m instanceof EntityModel) {
                EntityModel e = (EntityModel)m;
                e.getIdentityField().map(f -> (FieldModel)f).ifPresent(f -> f.setDomainMirror(this));
            }
            m.getAllFields().stream().map(f -> (FieldModel)f).forEach(f -> f.setDomainMirror(this));
            m.getMethods().stream().map(meth -> (MethodModel)meth).forEach(meth -> meth.setDomainMirror(this));
        });
        this.boundedContextMirrors.forEach(m -> {
            BoundedContextModel bc = (BoundedContextModel)m;
            bc.setDomainMirror(this);
        });
    }

    @JsonCreator
    public DomainModel(@JsonProperty(value="allTypeMirrors") Map<String, ? extends DomainTypeMirror> allTypeMirrors, @JsonProperty(value="boundedContextMirrors") List<BoundedContextMirror> boundedContextMirrors) {
        this.allTypeMirrors = new HashMap<String, DomainTypeMirror>(allTypeMirrors);
        this.boundedContextMirrors = boundedContextMirrors;
        this.initDomainModelReferences();
    }

    @Override
    public <T extends DomainTypeMirror> Optional<T> getDomainTypeMirror(String typeName) {
        return Optional.ofNullable(this.allTypeMirrors.get(typeName));
    }

    @Override
    @JsonIgnore
    public List<DomainTypeMirror> getAllDomainTypeMirrors() {
        return new ArrayList<DomainTypeMirror>(this.allTypeMirrors.values());
    }

    @Override
    @JsonIgnore
    public List<BoundedContextMirror> getAllBoundedContextMirrors() {
        return this.boundedContextMirrors;
    }

    private List<BoundedContextMirror> buildBoundedContextMirrors(String ... boundedContextPackages) {
        if (boundedContextPackages != null && boundedContextPackages.length > 0) {
            DomainModel.validatePackages(boundedContextPackages);
            return Arrays.stream(boundedContextPackages).map(BoundedContextModel::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    @JsonIgnore
    public List<AggregateRootMirror> getAllAggregateRootMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.AGGREGATE_ROOT)).map(dt -> (AggregateRootMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<EntityMirror> getAllEntityMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.ENTITY)).map(dt -> (EntityMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<ValueObjectMirror> getAllValueObjectMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.VALUE_OBJECT)).map(dt -> (ValueObjectMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<EnumMirror> getAllEnumMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.ENUM)).map(dt -> (EnumMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<ValueMirror> getAllValueMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.ENUM) || dt.getDomainType().equals((Object)DomainType.VALUE_OBJECT) || dt.getDomainType().equals((Object)DomainType.IDENTITY)).map(dt -> (ValueMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<DomainCommandMirror> getAllDomainCommandMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.DOMAIN_COMMAND)).map(dt -> (DomainCommandMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<DomainEventMirror> getAllDomainEventMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.DOMAIN_EVENT)).map(dt -> (DomainEventMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<ApplicationServiceMirror> getAllApplicationServiceMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.APPLICATION_SERVICE)).map(dt -> (ApplicationServiceMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<DomainServiceMirror> getAllDomainServiceMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.DOMAIN_SERVICE)).map(dt -> (DomainServiceMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<RepositoryMirror> getAllRepositoryMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.REPOSITORY)).map(dt -> (RepositoryMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<ReadModelMirror> getAllReadModelMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.READ_MODEL)).map(dt -> (ReadModelMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<QueryHandlerMirror> getAllQueryHandlerMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.QUERY_HANDLER)).map(dt -> (QueryHandlerMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<OutboundServiceMirror> getAllOutboundServiceMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.OUTBOUND_SERVICE)).map(dt -> (OutboundServiceMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<IdentityMirror> getAllIdentityMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.IDENTITY)).map(dt -> (IdentityMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<ServiceKindMirror> getAllUnspecifiedServiceKindMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.SERVICE_KIND)).map(dt -> (ServiceKindMirror)dt).toList();
    }

    @Override
    @JsonIgnore
    public List<ServiceKindMirror> getAllServiceKindMirrors() {
        return this.getAllDomainTypeMirrors().stream().filter(dt -> dt.getDomainType().equals((Object)DomainType.SERVICE_KIND) || dt.getDomainType().equals((Object)DomainType.APPLICATION_SERVICE) || dt.getDomainType().equals((Object)DomainType.DOMAIN_SERVICE) || dt.getDomainType().equals((Object)DomainType.REPOSITORY) || dt.getDomainType().equals((Object)DomainType.QUERY_HANDLER) || dt.getDomainType().equals((Object)DomainType.OUTBOUND_SERVICE)).map(dt -> (ServiceKindMirror)dt).toList();
    }

    private static void validatePackages(String ... packageNames) {
        for (String packageName : packageNames) {
            if (packagePattern.matcher(packageName).matches()) continue;
            throw MirrorException.fail("Invalid package name: " + packageName);
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainModel that = (DomainModel)o;
        return Objects.equals(this.allTypeMirrors, that.allTypeMirrors) && Objects.equals(this.boundedContextMirrors, that.boundedContextMirrors);
    }

    public int hashCode() {
        return Objects.hash(this.allTypeMirrors, this.boundedContextMirrors);
    }
}

