/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.domainlifecycles.mirror.api.DomainObjectMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.ValueReferenceMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import io.domainlifecycles.mirror.model.DomainTypeModel;
import java.util.List;
import java.util.stream.Collectors;

public abstract class DomainObjectModel
extends DomainTypeModel
implements DomainObjectMirror {
    public DomainObjectModel(String typeName, boolean isAbstract, List<FieldMirror> allFields, List<MethodMirror> methods, List<String> inheritanceHierarchyTypeNames, List<String> allInterfaceTypeNames) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
    }

    @Override
    @JsonIgnore
    public List<FieldMirror> getBasicFields() {
        return this.allFields.stream().filter(p -> DomainType.NON_DOMAIN.equals((Object)p.getType().getDomainType())).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<ValueReferenceMirror> getValueReferences() {
        return this.allFields.stream().filter(p -> DomainType.VALUE_OBJECT.equals((Object)p.getType().getDomainType()) || DomainType.ENUM.equals((Object)p.getType().getDomainType()) || DomainType.IDENTITY.equals((Object)p.getType().getDomainType())).map(p -> (ValueReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    public ValueReferenceMirror valueReferenceByName(String name) {
        return this.allFields.stream().filter(p -> p.getName().equals(name) && (DomainType.VALUE_OBJECT.equals((Object)p.getType().getDomainType()) || DomainType.ENUM.equals((Object)p.getType().getDomainType()) || DomainType.IDENTITY.equals((Object)p.getType().getDomainType()))).map(p -> (ValueReferenceMirror)p).findFirst().orElseThrow(() -> MirrorException.fail(String.format("ValueReferenceMirror not found for name '%s' within '%s'!", name, this.typeName)));
    }

    @Override
    public String toString() {
        return "DomainObjectModel{} " + super.toString();
    }
}

