/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import io.domainlifecycles.mirror.model.ProvidedDomain;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class DomainTypeModel
implements DomainTypeMirror,
ProvidedDomain {
    DomainMirror domainMirror;
    private boolean domainMirrorSet = false;
    protected final String typeName;
    protected final List<FieldMirror> allFields;
    protected final List<MethodMirror> methods;
    protected final boolean isAbstract;
    protected final List<String> inheritanceHierarchyTypeNames;
    protected final List<String> allInterfaceTypeNames;

    public DomainTypeModel(String typeName, boolean isAbstract, List<FieldMirror> allFields, List<MethodMirror> methods, List<String> inheritanceHierarchyTypeNames, List<String> allInterfaceTypeNames) {
        this.typeName = Objects.requireNonNull(typeName);
        this.isAbstract = isAbstract;
        Objects.requireNonNull(allFields);
        this.allFields = Collections.unmodifiableList(allFields);
        Objects.requireNonNull(methods);
        this.methods = Collections.unmodifiableList(methods);
        Objects.requireNonNull(inheritanceHierarchyTypeNames);
        this.inheritanceHierarchyTypeNames = Collections.unmodifiableList(inheritanceHierarchyTypeNames);
        Objects.requireNonNull(allInterfaceTypeNames);
        this.allInterfaceTypeNames = Collections.unmodifiableList(allInterfaceTypeNames);
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public abstract DomainType getDomainType();

    @Override
    public List<FieldMirror> getAllFields() {
        return this.allFields;
    }

    @Override
    public List<MethodMirror> getMethods() {
        return this.methods;
    }

    @Override
    public MethodMirror methodByName(String methodName) {
        return this.methods.stream().filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> MirrorException.fail(String.format("MethodMirror not found for method name '%s' within '%s'", methodName, this.typeName)));
    }

    @Override
    public FieldMirror fieldByName(String fieldName) {
        return this.allFields.stream().filter(f -> f.getName().equals(fieldName) && !f.isHidden()).findFirst().orElseThrow(() -> MirrorException.fail(String.format("FieldMirror not found for field name '%s' within '%s'", fieldName, this.typeName)));
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public List<String> getInheritanceHierarchyTypeNames() {
        return this.inheritanceHierarchyTypeNames;
    }

    @Override
    public boolean isSubClassOf(String typeName) {
        return typeName.equals(this.typeName) || this.inheritanceHierarchyTypeNames.contains(typeName);
    }

    @Override
    public boolean implementsInterface(String interfaceName) {
        return this.allInterfaceTypeNames.contains(interfaceName);
    }

    @Override
    public List<String> getAllInterfaceTypeNames() {
        return this.allInterfaceTypeNames;
    }

    public String toString() {
        return "DomainTypeModel{typeName='" + this.typeName + "', allFields=" + String.valueOf(this.allFields) + ", methods=" + String.valueOf(this.methods) + ", isAbstract=" + this.isAbstract + ", inheritanceHierarchyTypeNames=" + String.valueOf(this.inheritanceHierarchyTypeNames) + ", allInterfaceTypeNames=" + String.valueOf(this.allInterfaceTypeNames) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainTypeModel that = (DomainTypeModel)o;
        return this.isAbstract == that.isAbstract && this.typeName.equals(that.typeName) && this.allFields.equals(that.allFields) && this.methods.equals(that.methods) && this.inheritanceHierarchyTypeNames.equals(that.inheritanceHierarchyTypeNames) && this.allInterfaceTypeNames.equals(that.allInterfaceTypeNames);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.allFields, this.methods, this.isAbstract, this.inheritanceHierarchyTypeNames, this.allInterfaceTypeNames);
    }

    @Override
    public void setDomainMirror(DomainMirror domainMirror) {
        if (!this.domainMirrorSet) {
            this.domainMirror = domainMirror;
            this.domainMirrorSet = true;
        }
    }

    @Override
    public boolean domainMirrorSet() {
        return this.domainMirrorSet;
    }
}

