/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.AggregateRootReferenceMirror;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainObjectMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityMirror;
import io.domainlifecycles.mirror.api.EntityReferenceMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.ValueReferenceMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import io.domainlifecycles.mirror.model.DomainObjectModel;
import io.domainlifecycles.mirror.visitor.ContextDomainObjectVisitor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class EntityModel
extends DomainObjectModel
implements EntityMirror,
DomainObjectMirror {
    private final Optional<FieldMirror> identityField;
    private final Optional<FieldMirror> concurrencyVersionField;

    @JsonCreator
    public EntityModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="abstract") boolean isAbstract, @JsonProperty(value="allFields") List<FieldMirror> allFields, @JsonProperty(value="methods") List<MethodMirror> methods, @JsonProperty(value="identityField") Optional<FieldMirror> identityField, @JsonProperty(value="concurrencyVersionField") Optional<FieldMirror> concurrencyVersionField, @JsonProperty(value="inheritanceHierarchyTypeNames") List<String> inheritanceHierarchyTypeNames, @JsonProperty(value="allInterfaceTypeNames") List<String> allInterfaceTypeNames) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
        this.identityField = Objects.requireNonNull(identityField);
        this.concurrencyVersionField = Objects.requireNonNull(concurrencyVersionField);
    }

    @Override
    public Optional<FieldMirror> getIdentityField() {
        return this.identityField;
    }

    @Override
    public Optional<FieldMirror> getConcurrencyVersionField() {
        return this.concurrencyVersionField;
    }

    @Override
    @JsonIgnore
    public List<EntityReferenceMirror> getEntityReferences() {
        return this.allFields.stream().filter(p -> DomainType.ENTITY.equals((Object)p.getType().getDomainType())).map(p -> (EntityReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    public EntityReferenceMirror entityReferenceByName(String name) {
        return this.allFields.stream().filter(p -> DomainType.ENTITY.equals((Object)p.getType().getDomainType()) && p.getName().equals(name)).map(p -> (EntityReferenceMirror)p).findFirst().orElseThrow(() -> MirrorException.fail(String.format("EntityReferenceMirror not found for name '%s' within '%s'!", name, this.typeName)));
    }

    @Override
    @JsonIgnore
    public List<AggregateRootReferenceMirror> getAggregateRootReferences() {
        return this.allFields.stream().filter(p -> DomainType.AGGREGATE_ROOT.equals((Object)p.getType().getDomainType())).map(p -> (AggregateRootReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    public AggregateRootReferenceMirror aggregateRootReferenceByName(String name) {
        return this.allFields.stream().filter(p -> DomainType.AGGREGATE_ROOT.equals((Object)p.getType().getDomainType()) && p.getName().equals(name)).map(p -> (AggregateRootReferenceMirror)p).findFirst().orElseThrow(() -> MirrorException.fail(String.format("AggregateRootReferenceMirror not found for name '%s' within '%s'!", name, this.typeName)));
    }

    @Override
    @JsonIgnore
    public List<ValueReferenceMirror> getValueReferences() {
        return this.allFields.stream().filter(p -> DomainType.VALUE_OBJECT.equals((Object)p.getType().getDomainType()) || DomainType.ENUM.equals((Object)p.getType().getDomainType()) || DomainType.IDENTITY.equals((Object)p.getType().getDomainType()) && !p.getName().equals(this.getIdentityField().map(FieldMirror::getName).orElse(null))).map(p -> (ValueReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<FieldMirror> getBasicFields() {
        return this.identityField.map(fieldMirror -> super.getBasicFields().stream().filter(p -> !p.getName().equals(fieldMirror.getName())).collect(Collectors.toList())).orElseGet(() -> super.getBasicFields());
    }

    @Override
    public boolean publishes(final DomainEventMirror domainEvent) {
        final AtomicBoolean publishes = new AtomicBoolean(false);
        ContextDomainObjectVisitor visitor = new ContextDomainObjectVisitor(this){

            @Override
            public void visitEnterAnyDomainType(DomainTypeMirror domainTypeMirror) {
                if (!publishes.get()) {
                    publishes.set(domainTypeMirror.getMethods().stream().anyMatch(m -> m.publishes(domainEvent)));
                }
            }
        };
        visitor.start();
        return publishes.get();
    }

    @Override
    public boolean listensTo(final DomainEventMirror domainEvent) {
        final AtomicBoolean listensTo = new AtomicBoolean(false);
        ContextDomainObjectVisitor visitor = new ContextDomainObjectVisitor(this){

            @Override
            public void visitEnterAnyDomainType(DomainTypeMirror domainTypeMirror) {
                if (!listensTo.get()) {
                    listensTo.set(domainTypeMirror.getMethods().stream().anyMatch(m -> m.listensTo(domainEvent)));
                }
            }
        };
        visitor.start();
        return listensTo.get();
    }

    @Override
    public boolean processes(final DomainCommandMirror command) {
        final AtomicBoolean processes = new AtomicBoolean(false);
        ContextDomainObjectVisitor visitor = new ContextDomainObjectVisitor(this){

            @Override
            public void visitEnterAnyDomainType(DomainTypeMirror domainTypeMirror) {
                if (!processes.get()) {
                    processes.set(domainTypeMirror.getMethods().stream().anyMatch(m -> m.processes(command)));
                }
            }
        };
        visitor.start();
        return processes.get();
    }

    @Override
    @JsonIgnore
    public List<DomainCommandMirror> processedDomainCommands() {
        return this.methods.stream().flatMap(m -> m.getProcessedCommands().stream()).distinct().toList();
    }

    @Override
    @JsonIgnore
    public List<DomainEventMirror> publishedDomainEvents() {
        return this.methods.stream().flatMap(m -> m.getPublishedEvents().stream()).distinct().toList();
    }

    @Override
    @JsonIgnore
    public List<DomainEventMirror> listenedDomainEvents() {
        return this.methods.stream().flatMap(m -> m.getListenedEvent().stream()).distinct().toList();
    }

    @Override
    @JsonIgnore
    public DomainType getDomainType() {
        return DomainType.ENTITY;
    }

    @Override
    public String toString() {
        return "EntityModel{identityField=" + String.valueOf(this.identityField) + "concurrencyVersionField=" + String.valueOf(this.concurrencyVersionField) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EntityModel that = (EntityModel)o;
        return this.identityField.equals(that.identityField) && this.concurrencyVersionField.equals(that.concurrencyVersionField);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.identityField, this.concurrencyVersionField);
    }
}

