/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.EnumMirror;
import io.domainlifecycles.mirror.api.EnumOptionMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.model.DomainTypeModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class EnumModel
extends DomainTypeModel
implements EnumMirror {
    private final List<EnumOptionMirror> enumOptions;

    @JsonCreator
    public EnumModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="abstract") boolean isAbstract, @JsonProperty(value="allFields") List<FieldMirror> allFields, @JsonProperty(value="methods") List<MethodMirror> methods, @JsonProperty(value="enumOptions") List<EnumOptionMirror> enumOptions, @JsonProperty(value="inheritanceHierarchyTypeNames") List<String> inheritanceHierarchyTypeNames, @JsonProperty(value="allInterfaceTypeNames") List<String> allInterfaceTypeNames) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
        Objects.requireNonNull(enumOptions);
        this.enumOptions = Collections.unmodifiableList(enumOptions);
    }

    @Override
    public boolean isSingledValued() {
        return false;
    }

    @Override
    public Optional<FieldMirror> singledValuedField() {
        return Optional.empty();
    }

    @Override
    public List<EnumOptionMirror> getEnumOptions() {
        return this.enumOptions;
    }

    @Override
    @JsonIgnore
    public DomainType getDomainType() {
        return DomainType.ENUM;
    }

    @Override
    public String toString() {
        return "EnumModel{enumOptions=" + String.valueOf(this.enumOptions) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnumModel enumModel = (EnumModel)o;
        return this.enumOptions.equals(enumModel.enumOptions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.enumOptions);
    }
}

