/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.AccessLevel;
import io.domainlifecycles.mirror.api.AssertedContainableTypeMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.model.ProvidedDomain;
import java.util.Objects;
import java.util.Optional;

public class FieldModel
implements FieldMirror,
ProvidedDomain {
    protected final String name;
    protected final AssertedContainableTypeMirror type;
    protected final AccessLevel accessLevel;
    protected final String declaredByTypeName;
    protected final boolean publicReadable;
    protected final boolean publicWriteable;
    protected final boolean modifiable;
    protected final boolean isStatic;
    protected final boolean hidden;
    DomainMirror domainMirror;
    private boolean domainMirrorSet = false;

    @JsonCreator
    public FieldModel(@JsonProperty(value="name") String name, @JsonProperty(value="type") AssertedContainableTypeMirror type, @JsonProperty(value="accessLevel") AccessLevel accessLevel, @JsonProperty(value="declaredByTypeName") String declaredByTypeName, @JsonProperty(value="modifiable") boolean modifiable, @JsonProperty(value="publicReadable") boolean publicReadable, @JsonProperty(value="publicWriteable") boolean publicWriteable, @JsonProperty(value="static") boolean isStatic, @JsonProperty(value="hidden") boolean hidden) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.accessLevel = Objects.requireNonNull(accessLevel);
        this.declaredByTypeName = Objects.requireNonNull(declaredByTypeName);
        this.modifiable = modifiable;
        this.publicReadable = publicReadable;
        this.publicWriteable = publicWriteable;
        this.isStatic = isStatic;
        this.hidden = hidden;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AssertedContainableTypeMirror getType() {
        return this.type;
    }

    @Override
    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    @Override
    public String getDeclaredByTypeName() {
        return this.declaredByTypeName;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public boolean isPublicReadable() {
        return this.publicReadable;
    }

    @Override
    public boolean isPublicWriteable() {
        return this.publicWriteable;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    @JsonIgnore
    public boolean isIdentityField() {
        EntityMirror entityMirror;
        DomainTypeMirror domainTypeMirror;
        Optional domainTypeMirrorOptional = this.domainMirror.getDomainTypeMirror(this.declaredByTypeName);
        if (domainTypeMirrorOptional.isPresent() && ((domainTypeMirror = (DomainTypeMirror)domainTypeMirrorOptional.get()).getDomainType().equals((Object)DomainType.AGGREGATE_ROOT) || domainTypeMirror.getDomainType().equals((Object)DomainType.ENTITY)) && (entityMirror = (EntityMirror)domainTypeMirror).getIdentityField().isPresent()) {
            return entityMirror.getIdentityField().get().equals(this);
        }
        return false;
    }

    public String toString() {
        return "FieldModel{name='" + this.name + "', type=" + String.valueOf(this.type) + ", accessLevel=" + String.valueOf((Object)this.accessLevel) + ", declaredByTypeName='" + this.declaredByTypeName + "', publicReadable=" + this.publicReadable + ", publicWriteable=" + this.publicWriteable + ", modifiable=" + this.modifiable + ", static=" + this.isStatic + ", hidden=" + this.hidden + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldModel that = (FieldModel)o;
        return this.publicReadable == that.publicReadable && this.publicWriteable == that.publicWriteable && this.modifiable == that.modifiable && this.name.equals(that.name) && this.type.equals(that.type) && this.accessLevel == that.accessLevel && this.declaredByTypeName.equals(that.declaredByTypeName) && this.isStatic == that.isStatic && this.hidden == that.hidden;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.accessLevel, this.declaredByTypeName, this.publicReadable, this.publicWriteable, this.modifiable, this.isStatic, this.hidden});
    }

    @Override
    public void setDomainMirror(DomainMirror domainMirror) {
        if (!this.domainMirrorSet) {
            this.domainMirror = domainMirror;
            this.domainMirrorSet = true;
        }
    }

    @Override
    public boolean domainMirrorSet() {
        return this.domainMirrorSet;
    }
}

