/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.IdentityMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.model.DomainTypeModel;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IdentityModel
extends DomainTypeModel
implements IdentityMirror {
    private final Optional<String> valueTypeName;

    @JsonCreator
    public IdentityModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="abstract") boolean isAbstract, @JsonProperty(value="allFields") List<FieldMirror> allFields, @JsonProperty(value="methods") List<MethodMirror> methods, @JsonProperty(value="valueTypeName") Optional<String> valueTypeName, @JsonProperty(value="inheritanceHierarchyTypeNames") List<String> inheritanceHierarchyTypeNames, @JsonProperty(value="allInterfaceTypeNames") List<String> allInterfaceTypeNames) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
        this.valueTypeName = Objects.requireNonNull(valueTypeName);
    }

    @Override
    public Optional<String> getValueTypeName() {
        return this.valueTypeName;
    }

    @Override
    @JsonIgnore
    public DomainType getDomainType() {
        return DomainType.IDENTITY;
    }

    @Override
    public boolean isSingledValued() {
        return true;
    }

    @Override
    public Optional<FieldMirror> singledValuedField() {
        return this.allFields.stream().filter(p -> p.isPublicReadable() && !p.isStatic()).findFirst();
    }

    @Override
    public String toString() {
        return "IdentityModel{valueTypeName='" + String.valueOf(this.valueTypeName) + "'} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdentityModel that = (IdentityModel)o;
        return this.valueTypeName.equals(that.valueTypeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.valueTypeName);
    }
}

