/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.AccessLevel;
import io.domainlifecycles.mirror.api.AssertedContainableTypeMirror;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.ParamMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import io.domainlifecycles.mirror.model.ProvidedDomain;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class MethodModel
implements MethodMirror,
ProvidedDomain {
    private final String name;
    private final String declaredByTypeName;
    private final AccessLevel accessLevel;
    private final List<ParamMirror> parameters;
    private final AssertedContainableTypeMirror returnType;
    DomainMirror domainMirror;
    private boolean domainMirrorSet = false;
    @JsonProperty
    private final List<String> publishedEventTypeNames;
    @JsonProperty
    private final Optional<String> listenedEventTypeName;
    private final boolean overridden;

    @JsonCreator
    public MethodModel(@JsonProperty(value="name") String name, @JsonProperty(value="declaredByTypeName") String declaredByTypeName, @JsonProperty(value="accessLevel") AccessLevel accessLevel, @JsonProperty(value="parameters") List<ParamMirror> parameters, @JsonProperty(value="returnType") AssertedContainableTypeMirror returnType, @JsonProperty(value="overridden") boolean overridden, @JsonProperty(value="publishedEventTypeNames") List<String> publishedEventTypeNames, @JsonProperty(value="listenedEventTypeName") Optional<String> listenedEventTypeName) {
        this.name = Objects.requireNonNull(name);
        this.declaredByTypeName = Objects.requireNonNull(declaredByTypeName);
        this.accessLevel = Objects.requireNonNull(accessLevel);
        Objects.requireNonNull(parameters);
        this.parameters = Collections.unmodifiableList(parameters);
        this.returnType = Objects.requireNonNull(returnType);
        this.overridden = overridden;
        Objects.requireNonNull(publishedEventTypeNames);
        this.publishedEventTypeNames = Collections.unmodifiableList(publishedEventTypeNames);
        this.listenedEventTypeName = Objects.requireNonNull(listenedEventTypeName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDeclaredByTypeName() {
        return this.declaredByTypeName;
    }

    @Override
    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    @Override
    public List<ParamMirror> getParameters() {
        return this.parameters;
    }

    @Override
    public AssertedContainableTypeMirror getReturnType() {
        return this.returnType;
    }

    @Override
    @JsonIgnore
    public List<DomainEventMirror> getPublishedEvents() {
        return this.publishedEventTypeNames.stream().map(n -> (DomainEventMirror)this.domainMirror.getDomainTypeMirror((String)n).orElseThrow(() -> MirrorException.fail("DomainEventMirror not found for '%s'", n))).distinct().collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public Optional<DomainEventMirror> getListenedEvent() {
        return this.listenedEventTypeName.map(n -> (DomainEventMirror)this.domainMirror.getDomainTypeMirror((String)n).orElseThrow(() -> MirrorException.fail("DomainEventMirror not found for '%s'", n)));
    }

    @Override
    @JsonIgnore
    public List<DomainCommandMirror> getProcessedCommands() {
        return this.parameters.stream().filter(p -> p.getType().getDomainType().equals((Object)DomainType.DOMAIN_COMMAND)).map(p -> (DomainCommandMirror)this.domainMirror.getDomainTypeMirror(p.getType().getTypeName()).orElseThrow(() -> MirrorException.fail("DomainCommandMirror not found for '%s'", p.getType().getTypeName()))).distinct().toList();
    }

    @Override
    public boolean publishes(DomainEventMirror domainEvent) {
        return this.getPublishedEvents().stream().anyMatch(p -> p.equals(domainEvent));
    }

    @Override
    public boolean listensTo(DomainEventMirror domainEvent) {
        return this.getListenedEvent().isPresent() && this.getListenedEvent().get().equals(domainEvent);
    }

    @Override
    public boolean processes(DomainCommandMirror command) {
        return this.parameters.stream().anyMatch(p -> p.getType().getTypeName().equals(command.getTypeName()));
    }

    @Override
    public boolean isGetter() {
        Optional declaringDomainTypeOptional;
        if (this.parameters.isEmpty() && AccessLevel.PUBLIC.equals((Object)this.accessLevel) && (declaringDomainTypeOptional = this.domainMirror.getDomainTypeMirror(this.declaredByTypeName)).isPresent()) {
            DomainTypeMirror declaringDomainType = (DomainTypeMirror)declaringDomainTypeOptional.get();
            Object propName = this.name;
            if (this.name.startsWith("get")) {
                propName = ((String)propName).substring(3);
            } else if (this.name.startsWith("is")) {
                propName = ((String)propName).substring(2);
            }
            if (!((String)propName).isEmpty()) {
                Object propNameFinal = propName = ((String)propName).substring(0, 1).toLowerCase() + ((String)propName).substring(1);
                return declaringDomainType.getAllFields().stream().anyMatch(arg_0 -> this.lambda$isGetter$9((String)propNameFinal, arg_0));
            }
        }
        return false;
    }

    @Override
    public boolean isSetter() {
        Optional declaringDomainTypeOptional;
        if (this.parameters.size() == 1 && AccessLevel.PUBLIC.equals((Object)this.accessLevel) && (declaringDomainTypeOptional = this.domainMirror.getDomainTypeMirror(this.declaredByTypeName)).isPresent()) {
            DomainTypeMirror declaringDomainType = (DomainTypeMirror)declaringDomainTypeOptional.get();
            Object propName = this.name;
            if (this.name.startsWith("set")) {
                propName = ((String)propName).substring(3);
            }
            if (!((String)propName).isEmpty()) {
                Object propNameFinal = propName = ((String)propName).substring(0, 1).toLowerCase() + ((String)propName).substring(1);
                ParamMirror firstParam = this.parameters.get(0);
                return declaringDomainType.getAllFields().stream().anyMatch(arg_0 -> MethodModel.lambda$isSetter$10((String)propNameFinal, firstParam, arg_0));
            }
        }
        return false;
    }

    @Override
    public boolean isOverridden() {
        return this.overridden;
    }

    public String toString() {
        return "MethodModel{name='" + this.name + "', declaredByTypeName='" + this.declaredByTypeName + "', accessLevel=" + String.valueOf((Object)this.accessLevel) + ", parameters=" + String.valueOf(this.parameters) + ", returnType=" + String.valueOf(this.returnType) + ", overridden=" + this.overridden + ", publishedEventTypeNames=" + String.valueOf(this.publishedEventTypeNames) + ", listenedEventTypeName=" + String.valueOf(this.listenedEventTypeName) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodModel that = (MethodModel)o;
        return this.name.equals(that.name) && this.declaredByTypeName.equals(that.declaredByTypeName) && this.accessLevel == that.accessLevel && this.parameters.equals(that.parameters) && this.returnType.equals(that.returnType) && this.publishedEventTypeNames.equals(that.publishedEventTypeNames) && this.listenedEventTypeName.equals(that.listenedEventTypeName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.declaredByTypeName, this.accessLevel, this.parameters, this.returnType, this.publishedEventTypeNames, this.listenedEventTypeName});
    }

    @Override
    public void setDomainMirror(DomainMirror domainModel) {
        if (!this.domainMirrorSet) {
            this.domainMirror = domainModel;
            this.domainMirrorSet = true;
        }
    }

    @Override
    public boolean domainMirrorSet() {
        return this.domainMirrorSet;
    }

    private static /* synthetic */ boolean lambda$isSetter$10(String propNameFinal, ParamMirror firstParam, FieldMirror p) {
        return p.getName().equals(propNameFinal) && p.getType().getTypeName().equals(firstParam.getType().getTypeName());
    }

    private /* synthetic */ boolean lambda$isGetter$9(String propNameFinal, FieldMirror p) {
        return p.getName().equals(propNameFinal) && p.getType().getTypeName().equals(this.returnType.getTypeName());
    }
}

