/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.ReadModelMirror;
import io.domainlifecycles.mirror.model.ServiceKindModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryHandlerModel
extends ServiceKindModel
implements QueryHandlerMirror {
    @JsonProperty
    private final String providedReadModelTypeName;
    @JsonProperty
    private final List<String> queryHandlerInterfaceTypeNames;

    @JsonCreator
    public QueryHandlerModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="abstract") boolean isAbstract, @JsonProperty(value="allFields") List<FieldMirror> allFields, @JsonProperty(value="methods") List<MethodMirror> methods, @JsonProperty(value="queryHandlerInterfaceTypeNames") List<String> queryHandlerInterfaceTypeNames, @JsonProperty(value="inheritanceHierarchyTypeNames") List<String> inheritanceHierarchyTypeNames, @JsonProperty(value="allInterfaceTypeNames") List<String> allInterfaceTypeNames, @JsonProperty(value="providedReadModelTypeName") String providedReadModelTypeName) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
        this.providedReadModelTypeName = Objects.requireNonNull(providedReadModelTypeName);
        this.queryHandlerInterfaceTypeNames = Collections.unmodifiableList(queryHandlerInterfaceTypeNames);
    }

    @Override
    public Optional<ReadModelMirror> getProvidedReadModel() {
        return Optional.ofNullable(this.domainMirror.getDomainTypeMirror(this.providedReadModelTypeName).orElse(null));
    }

    @Override
    public List<String> getQueryHandlerInterfaceTypeNames() {
        return this.queryHandlerInterfaceTypeNames;
    }

    @Override
    public DomainType getDomainType() {
        return DomainType.QUERY_HANDLER;
    }

    @Override
    public String toString() {
        return "QueryHandlerModel{providedReadModelTypeName='" + this.providedReadModelTypeName + "', queryHandlerInterfaceTypeNames=" + String.valueOf(this.queryHandlerInterfaceTypeNames) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QueryHandlerModel that = (QueryHandlerModel)o;
        return this.providedReadModelTypeName.equals(that.providedReadModelTypeName) && this.queryHandlerInterfaceTypeNames.equals(that.queryHandlerInterfaceTypeNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.providedReadModelTypeName, this.queryHandlerInterfaceTypeNames);
    }
}

