/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.AggregateRootReferenceMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.EntityReferenceMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.ReadModelMirror;
import io.domainlifecycles.mirror.api.ValueReferenceMirror;
import io.domainlifecycles.mirror.model.DomainTypeModel;
import java.util.List;
import java.util.stream.Collectors;

public class ReadModelModel
extends DomainTypeModel
implements ReadModelMirror {
    @JsonCreator
    public ReadModelModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="abstract") boolean isAbstract, @JsonProperty(value="allFields") List<FieldMirror> allFields, @JsonProperty(value="methods") List<MethodMirror> methods, @JsonProperty(value="inheritanceHierarchyTypeNames") List<String> inheritanceHierarchyTypeNames, @JsonProperty(value="allInterfaceTypeNames") List<String> allInterfaceTypeNames) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
    }

    @Override
    @JsonIgnore
    public List<FieldMirror> getBasicFields() {
        return this.allFields.stream().filter(p -> DomainType.NON_DOMAIN.equals((Object)p.getType().getDomainType())).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<ValueReferenceMirror> getValueReferences() {
        return this.allFields.stream().filter(p -> DomainType.VALUE_OBJECT.equals((Object)p.getType().getDomainType()) || DomainType.ENUM.equals((Object)p.getType().getDomainType()) || DomainType.IDENTITY.equals((Object)p.getType().getDomainType())).map(p -> (ValueReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<EntityReferenceMirror> getEntityReferences() {
        return this.allFields.stream().filter(p -> DomainType.ENTITY.equals((Object)p.getType().getDomainType())).map(p -> (EntityReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<AggregateRootReferenceMirror> getAggregateRootReferences() {
        return this.allFields.stream().filter(p -> DomainType.AGGREGATE_ROOT.equals((Object)p.getType().getDomainType())).map(p -> (AggregateRootReferenceMirror)p).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public DomainType getDomainType() {
        return DomainType.READ_MODEL;
    }

    @Override
    public String toString() {
        return "ReadModelModel{} " + super.toString();
    }
}

