/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.model.ServiceKindModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RepositoryModel
extends ServiceKindModel
implements RepositoryMirror {
    @JsonProperty
    private final String managedAggregateTypeName;
    @JsonProperty
    private final List<String> repositoryInterfaceTypeNames;

    @JsonCreator
    public RepositoryModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="abstract") boolean isAbstract, @JsonProperty(value="allFields") List<FieldMirror> allFields, @JsonProperty(value="methods") List<MethodMirror> methods, @JsonProperty(value="managedAggregateTypeName") String managedAggregateTypeName, @JsonProperty(value="repositoryInterfaceTypeNames") List<String> repositoryInterfaceTypeNames, @JsonProperty(value="inheritanceHierarchyTypeNames") List<String> inheritanceHierarchyTypeNames, @JsonProperty(value="allInterfaceTypeNames") List<String> allInterfaceTypeNames) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
        this.managedAggregateTypeName = Objects.requireNonNull(managedAggregateTypeName);
        this.repositoryInterfaceTypeNames = Collections.unmodifiableList(repositoryInterfaceTypeNames);
    }

    @Override
    @JsonIgnore
    public Optional<AggregateRootMirror> getManagedAggregate() {
        return Optional.ofNullable(this.domainMirror.getDomainTypeMirror(this.managedAggregateTypeName).orElse(null));
    }

    @Override
    @JsonIgnore
    public DomainType getDomainType() {
        return DomainType.REPOSITORY;
    }

    @Override
    @JsonIgnore
    public List<String> getRepositoryInterfaceTypeNames() {
        return this.repositoryInterfaceTypeNames;
    }

    @Override
    public String toString() {
        return "RepositoryModel{managedAggregateTypeName='" + this.managedAggregateTypeName + "', repositoryInterfaceTypeNames=" + String.valueOf(this.repositoryInterfaceTypeNames) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RepositoryModel that = (RepositoryModel)o;
        return this.managedAggregateTypeName.equals(that.managedAggregateTypeName) && this.repositoryInterfaceTypeNames.equals(that.repositoryInterfaceTypeNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.managedAggregateTypeName, this.repositoryInterfaceTypeNames);
    }
}

