/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import io.domainlifecycles.mirror.api.ResolvedGenericTypeMirror;
import io.domainlifecycles.mirror.api.WildcardBound;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public record ResolvedGenericTypeModel(String typeName, boolean isArray, List<ResolvedGenericTypeMirror> genericTypes, Optional<WildcardBound> wildcardBound) implements ResolvedGenericTypeMirror
{
    @Override
    public String resolvedTypeDescription(boolean shortTypeNames) {
        StringBuilder desc = new StringBuilder();
        this.wildcardBound.ifPresent(bound -> desc.append(bound.equals((Object)WildcardBound.UPPER) ? "? extends " : "? super "));
        desc.append(this.typeName(this.typeName, shortTypeNames));
        if (this.genericTypes != null && !this.genericTypes.isEmpty()) {
            desc.append("<");
            desc.append(this.genericTypes.stream().map(gt -> gt.resolvedTypeDescription(shortTypeNames)).collect(Collectors.joining(", ")));
            desc.append(">");
        }
        return desc.toString();
    }

    @Override
    public String resolvedTypeDescriptionFirstLevel(boolean shortTypeNames) {
        StringBuilder desc = new StringBuilder();
        this.wildcardBound.ifPresent(bound -> desc.append(bound.equals((Object)WildcardBound.UPPER) ? "? extends " : "? super "));
        desc.append(this.typeName(this.typeName, shortTypeNames));
        if (this.genericTypes != null && !this.genericTypes.isEmpty()) {
            desc.append("<");
            desc.append(this.genericTypes.stream().map(gt -> {
                Object s = "";
                if (gt.wildcardBound().isPresent()) {
                    s = gt.wildcardBound().get().equals((Object)WildcardBound.UPPER) ? "? extends " : "? super ";
                }
                s = (String)s + this.typeName(gt.typeName(), shortTypeNames);
                return s;
            }).collect(Collectors.joining(", ")));
            desc.append(">");
        }
        return desc.toString();
    }

    private String typeName(String typeName, boolean shortTypeNames) {
        Objects.requireNonNull(typeName, "A type name is obligatory!");
        return shortTypeNames ? typeName.substring(typeName.lastIndexOf(".") + 1) : typeName;
    }
}

