/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.ApplicationServiceMirror;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainServiceMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.OutboundServiceMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import io.domainlifecycles.mirror.model.DomainTypeModel;
import java.util.List;
import java.util.stream.Collectors;

public class ServiceKindModel
extends DomainTypeModel
implements ServiceKindMirror {
    public ServiceKindModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="abstract") boolean isAbstract, @JsonProperty(value="allFields") List<FieldMirror> allFields, @JsonProperty(value="methods") List<MethodMirror> methods, @JsonProperty(value="inheritanceHierarchyTypeNames") List<String> inheritanceHierarchyTypeNames, @JsonProperty(value="allInterfaceTypeNames") List<String> allInterfaceTypeNames) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
    }

    @Override
    public boolean publishes(DomainEventMirror domainEvent) {
        return this.getMethods().stream().anyMatch(m -> m.publishes(domainEvent));
    }

    @Override
    public boolean listensTo(DomainEventMirror domainEvent) {
        return this.getMethods().stream().anyMatch(m -> m.listensTo(domainEvent));
    }

    @Override
    public boolean processes(DomainCommandMirror command) {
        return this.getMethods().stream().anyMatch(m -> m.processes(command));
    }

    @Override
    @JsonIgnore
    public DomainType getDomainType() {
        return DomainType.SERVICE_KIND;
    }

    @Override
    @JsonIgnore
    public List<ServiceKindMirror> getReferencedServiceKinds() {
        return this.allFields.stream().filter(fieldMirror -> DomainType.SERVICE_KIND.equals((Object)fieldMirror.getType().getDomainType()) || DomainType.REPOSITORY.equals((Object)fieldMirror.getType().getDomainType()) || DomainType.DOMAIN_SERVICE.equals((Object)fieldMirror.getType().getDomainType()) || DomainType.OUTBOUND_SERVICE.equals((Object)fieldMirror.getType().getDomainType()) || DomainType.QUERY_HANDLER.equals((Object)fieldMirror.getType().getDomainType()) || DomainType.APPLICATION_SERVICE.equals((Object)fieldMirror.getType().getDomainType())).map(this::mapToServiceKindMirror).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<RepositoryMirror> getReferencedRepositories() {
        return this.allFields.stream().filter(fieldMirror -> DomainType.REPOSITORY.equals((Object)fieldMirror.getType().getDomainType())).map(this::mapToRepositoryMirror).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<DomainServiceMirror> getReferencedDomainServices() {
        return this.allFields.stream().filter(fieldMirror -> DomainType.DOMAIN_SERVICE.equals((Object)fieldMirror.getType().getDomainType())).map(this::mapToDomainServiceMirror).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<OutboundServiceMirror> getReferencedOutboundServices() {
        return this.allFields.stream().filter(fieldMirror -> DomainType.OUTBOUND_SERVICE.equals((Object)fieldMirror.getType().getDomainType())).map(this::mapToOutboundServiceMirror).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<QueryHandlerMirror> getReferencedQueryHandlers() {
        return this.allFields.stream().filter(fieldMirror -> DomainType.QUERY_HANDLER.equals((Object)fieldMirror.getType().getDomainType())).map(this::mapToQueryHandlerMirror).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<ApplicationServiceMirror> getReferencedApplicationServices() {
        return this.allFields.stream().filter(fieldMirror -> DomainType.APPLICATION_SERVICE.equals((Object)fieldMirror.getType().getDomainType())).map(this::mapToApplicationServiceMirror).collect(Collectors.toList());
    }

    @Override
    @JsonIgnore
    public List<DomainCommandMirror> processedDomainCommands() {
        return this.methods.stream().flatMap(m -> m.getProcessedCommands().stream()).distinct().toList();
    }

    @Override
    @JsonIgnore
    public List<DomainEventMirror> publishedDomainEvents() {
        return this.methods.stream().flatMap(m -> m.getPublishedEvents().stream()).distinct().toList();
    }

    @Override
    @JsonIgnore
    public List<DomainEventMirror> listenedDomainEvents() {
        return this.methods.stream().flatMap(m -> m.getListenedEvent().stream()).distinct().toList();
    }

    private ServiceKindMirror mapToServiceKindMirror(FieldMirror fieldMirror) {
        return (ServiceKindMirror)this.domainMirror.getDomainTypeMirror(fieldMirror.getType().getTypeName()).orElseThrow(() -> MirrorException.fail(String.format("No ServiceKindMirror found for FieldMirror with type name '%s'.", fieldMirror.getType().getTypeName())));
    }

    private RepositoryMirror mapToRepositoryMirror(FieldMirror fieldMirror) {
        return (RepositoryMirror)this.domainMirror.getDomainTypeMirror(fieldMirror.getType().getTypeName()).orElseThrow(() -> MirrorException.fail(String.format("No RepositoryMirror found for FieldMirror with type name '%s'.", fieldMirror.getType().getTypeName())));
    }

    private DomainServiceMirror mapToDomainServiceMirror(FieldMirror fieldMirror) {
        return (DomainServiceMirror)this.domainMirror.getDomainTypeMirror(fieldMirror.getType().getTypeName()).orElseThrow(() -> MirrorException.fail(String.format("No DomainServiceMirror found for FieldMirror with type name '%s'.", fieldMirror.getType().getTypeName())));
    }

    private OutboundServiceMirror mapToOutboundServiceMirror(FieldMirror fieldMirror) {
        return (OutboundServiceMirror)this.domainMirror.getDomainTypeMirror(fieldMirror.getType().getTypeName()).orElseThrow(() -> MirrorException.fail(String.format("No OutboundServiceMirror found for FieldMirror with type name '%s'.", fieldMirror.getType().getTypeName())));
    }

    private QueryHandlerMirror mapToQueryHandlerMirror(FieldMirror fieldMirror) {
        return (QueryHandlerMirror)this.domainMirror.getDomainTypeMirror(fieldMirror.getType().getTypeName()).orElseThrow(() -> MirrorException.fail(String.format("No QueryHandlerMirror found for FieldMirror with type name '%s'.", fieldMirror.getType().getTypeName())));
    }

    private ApplicationServiceMirror mapToApplicationServiceMirror(FieldMirror fieldMirror) {
        return (ApplicationServiceMirror)this.domainMirror.getDomainTypeMirror(fieldMirror.getType().getTypeName()).orElseThrow(() -> MirrorException.fail(String.format("No ApplicationServiceMirror found for FieldMirror with type name '%s'.", fieldMirror.getType().getTypeName())));
    }
}

