/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.domainlifecycles.mirror.api.DomainObjectMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.ValueMirror;
import io.domainlifecycles.mirror.api.ValueObjectMirror;
import io.domainlifecycles.mirror.api.ValueReferenceMirror;
import io.domainlifecycles.mirror.model.DomainObjectModel;
import java.util.List;
import java.util.Optional;

public class ValueObjectModel
extends DomainObjectModel
implements ValueObjectMirror,
DomainObjectMirror {
    @JsonCreator
    public ValueObjectModel(@JsonProperty(value="typeName") String typeName, @JsonProperty(value="abstract") boolean isAbstract, @JsonProperty(value="allFields") List<FieldMirror> allFields, @JsonProperty(value="methods") List<MethodMirror> methods, @JsonProperty(value="inheritanceHierarchyTypeNames") List<String> inheritanceHierarchyTypeNames, @JsonProperty(value="allInterfaceTypeNames") List<String> allInterfaceTypeNames) {
        super(typeName, isAbstract, allFields, methods, inheritanceHierarchyTypeNames, allInterfaceTypeNames);
    }

    @Override
    @JsonIgnore
    public boolean isSingledValued() {
        List<ValueReferenceMirror> valueReferences = this.getValueReferences().stream().filter(vr -> !vr.isStatic() && !vr.isHidden()).toList();
        long basicReferencesCount = this.getBasicFields().stream().filter(f -> !f.isStatic() && !f.isHidden()).count();
        if (valueReferences.isEmpty()) {
            return basicReferencesCount == 1L;
        }
        if (valueReferences.size() == 1 && basicReferencesCount == 0L) {
            ValueMirror value = valueReferences.get(0).getValue();
            return value.isSingledValued() || value.isEnum() || value.isIdentity();
        }
        return false;
    }

    @Override
    @JsonIgnore
    public Optional<FieldMirror> singledValuedField() {
        List<ValueReferenceMirror> valueReferences = this.getValueReferences().stream().filter(vr -> !vr.isStatic() && !vr.isHidden()).toList();
        long basicReferencesCount = this.getBasicFields().stream().filter(f -> !f.isStatic() && !f.isHidden()).count();
        if (valueReferences.isEmpty() && basicReferencesCount == 1L) {
            return this.getBasicFields().stream().filter(f -> !f.isStatic() && !f.isHidden()).findFirst();
        }
        if (valueReferences.size() == 1 && basicReferencesCount == 0L) {
            return Optional.of((FieldMirror)valueReferences.get(0));
        }
        return Optional.empty();
    }

    @Override
    @JsonIgnore
    public DomainType getDomainType() {
        return DomainType.VALUE_OBJECT;
    }

    @Override
    public String toString() {
        return "ValueObjectModel{} " + super.toString();
    }
}

