/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.mirror.api.AssertedContainableTypeMirror;
import io.domainlifecycles.mirror.api.AssertionMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.ResolvedGenericTypeMirror;
import io.domainlifecycles.mirror.model.AssertedContainableTypeModel;
import io.domainlifecycles.mirror.reflect.AssertionMirrorBuilder;
import io.domainlifecycles.reflect.JavaReflect;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AssertedContainableTypeMirrorBuilder {
    private final Class<?> type;
    private final AnnotatedType annotatedType;
    private final Type genericType;
    private final ResolvedGenericTypeMirror resolvedGenericType;

    public AssertedContainableTypeMirrorBuilder(Class<?> type, AnnotatedType annotatedType, Type genericType, ResolvedGenericTypeMirror resolvedGenericType) {
        this.type = Objects.requireNonNull(type);
        this.annotatedType = Objects.requireNonNull(annotatedType);
        this.genericType = genericType;
        this.resolvedGenericType = resolvedGenericType;
    }

    public AssertedContainableTypeMirror build() {
        Optional<String> containerType = this.getContainerTypeName();
        List<AssertionMirror> assertions = containerType.isEmpty() ? this.buildAssertionMirrors() : this.buildContainedAssertionMirrors();
        List<AssertionMirror> containerAssertions = containerType.isPresent() ? this.buildAssertionMirrors() : Collections.emptyList();
        return new AssertedContainableTypeModel(this.getTypeName(), DomainType.of(this.getBasicType()), assertions, Optional.class.isAssignableFrom(this.type), Collection.class.isAssignableFrom(this.type), List.class.isAssignableFrom(this.type), Set.class.isAssignableFrom(this.type), Stream.class.isAssignableFrom(this.type), this.type.isArray(), containerType.orElse(null), containerAssertions, this.resolvedGenericType);
    }

    private List<AssertionMirror> buildAssertionMirrors() {
        return Arrays.stream(this.annotatedType.getAnnotations()).map(a -> {
            AssertionMirrorBuilder assertionMirrorBuilder = new AssertionMirrorBuilder(this.getBasicType(), (Annotation)a, false, Collection.class.isAssignableFrom(this.type));
            return assertionMirrorBuilder.build();
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<AssertionMirror> buildContainedAssertionMirrors() {
        AnnotatedType[] actualTypeArguments;
        if (AnnotatedParameterizedType.class.isAssignableFrom(this.annotatedType.getClass()) && (actualTypeArguments = ((AnnotatedParameterizedType)this.annotatedType).getAnnotatedActualTypeArguments()).length > 0) {
            return Arrays.stream(actualTypeArguments[0].getAnnotations()).map(a -> {
                AssertionMirrorBuilder assertionMirrorBuilder = new AssertionMirrorBuilder(this.getBasicType(), (Annotation)a, true, Collection.class.isAssignableFrom(this.type));
                return assertionMirrorBuilder.build();
            }).filter(Optional::isPresent).map(Optional::get).toList();
        }
        return List.of();
    }

    private Optional<String> getContainerTypeName() {
        if (Optional.class.isAssignableFrom(this.type) || Collection.class.isAssignableFrom(this.type) || Stream.class.isAssignableFrom(this.type)) {
            return Optional.of(this.type.getName());
        }
        return Optional.empty();
    }

    public Type getBasicType() {
        if (Optional.class.isAssignableFrom(this.type) || Collection.class.isAssignableFrom(this.type) || Stream.class.isAssignableFrom(this.type)) {
            return (Type)((Object)JavaReflect.getFirstParameterType((Type)this.genericType).orElse(Object.class));
        }
        if (this.type.isArray()) {
            return this.type.componentType();
        }
        return this.type;
    }

    private String getTypeName() {
        if (this.resolvedGenericType == null) {
            return this.getBasicType().getTypeName();
        }
        if (Optional.class.isAssignableFrom(this.type) || Collection.class.isAssignableFrom(this.type) || Stream.class.isAssignableFrom(this.type)) {
            return this.resolvedGenericType.genericTypes().get(0).typeName();
        }
        return this.resolvedGenericType.typeName();
    }
}

