/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.mirror.api.AssertionMirror;
import io.domainlifecycles.mirror.model.AssertionModel;
import io.domainlifecycles.mirror.model.AssertionType;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Null;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Digits;
import javax.validation.constraints.FutureOrPresent;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PastOrPresent;
import javax.validation.constraints.Size;

public class AssertionMirrorBuilder {
    private final Type annotatedType;
    private final Annotation annotation;
    private final boolean contained;
    private final boolean isCollection;
    private final String VALID_PACKAGE_NAME_JAVAX = "javax.validation.constraints";
    private final String VALID_PACKAGE_NAME_JAKARTA = "jakarta.validation.constraints";

    public AssertionMirrorBuilder(Type annotatedType, Annotation annotation, boolean contained, boolean isCollection) {
        this.annotatedType = Objects.requireNonNull(annotatedType);
        this.annotation = Objects.requireNonNull(annotation);
        this.contained = contained;
        this.isCollection = isCollection;
    }

    public Optional<AssertionMirror> build() {
        if (this.isNullAnnotation()) {
            return this.buildAssertionMirrorForNullAnnotation();
        }
        if (this.isNotNullAnnotation()) {
            return this.buildAssertionMirrorForNotNullAnnotation();
        }
        if (this.isNotNullAnnotation()) {
            return this.buildAssertionMirrorForNotNullAnnotation();
        }
        if (this.isAssertTrueAnnotation()) {
            return this.buildAssertionMirrorForAssertTrueAnnotation();
        }
        if (this.isAssertFalseAnnotation()) {
            return this.buildAssertionMirrorForAssertFalseAnnotation();
        }
        if (this.isMinAnnotation()) {
            return this.buildAssertionMirrorForMinAnnotation();
        }
        if (this.isMaxAnnotation()) {
            return this.buildAssertionMirrorForMaxAnnotation();
        }
        if (this.isDecimalMinAnnotation()) {
            return this.buildAssertionMirrorForDecimalMinAnnotation();
        }
        if (this.isDecimalMaxAnnotation()) {
            return this.buildAssertionMirrorForDecimalMaxAnnotation();
        }
        if (this.isNegativeAnnotation()) {
            return this.buildAssertionMirrorForNegativeAnnotation();
        }
        if (this.isNegativeOrZeroAnnotation()) {
            return this.buildAssertionMirrorForNegativeOrZeroAnnotation();
        }
        if (this.isPositiveAnnotation()) {
            return this.buildAssertionMirrorForPositiveAnnotation();
        }
        if (this.isPositiveOrZeroAnnotation()) {
            return this.buildAssertionMirrorForPositiveOrZeroAnnotation();
        }
        if (this.isSizeAnnotation()) {
            return this.buildAssertionMirrorForSizeAnnotation();
        }
        if (this.isDigitsAnnotation()) {
            return this.buildAssertionMirrorForDigitsAnnotation();
        }
        if (this.isPastAnnotation()) {
            return this.buildAssertionMirrorForPastAnnotation();
        }
        if (this.isPastOrPresentAnnotation()) {
            return this.buildAssertionMirrorForPastOrPresentAnnotation();
        }
        if (this.isFutureAnnotation()) {
            return this.buildAssertionMirrorForFutureAnnotation();
        }
        if (this.isFutureOrPresentAnnotation()) {
            return this.buildAssertionMirrorForFutureOrPresentAnnotation();
        }
        if (this.isPatternAnnotation()) {
            return this.buildAssertionMirrorForPatternAnnotation();
        }
        if (this.isNotEmptyAnnotation()) {
            return this.buildAssertionMirrorForNotEmptyAnnotation();
        }
        if (this.isNotBlankAnnotation()) {
            return this.buildAssertionMirrorForNotBlankAnnotation();
        }
        if (this.isEmailAnnotation()) {
            return this.buildAssertionMirrorForEmailAnnotation();
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForNullAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            Null nullAnnotation = (Null)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isNull, null, null, nullAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.Null nullAnnotation = (javax.validation.constraints.Null)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isNull, null, null, nullAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForNotNullAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            jakarta.validation.constraints.NotNull notNullAnnotation = (jakarta.validation.constraints.NotNull)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isNotNull, null, null, notNullAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            NotNull notNullAnnotation = (NotNull)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isNotNull, null, null, notNullAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForAssertTrueAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            jakarta.validation.constraints.AssertTrue assertTrueAnnotation = (jakarta.validation.constraints.AssertTrue)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isTrue, null, null, assertTrueAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            AssertTrue assertTrueAnnotation = (AssertTrue)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isTrue, null, null, assertTrueAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForAssertFalseAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            AssertFalse assertFalseAnnotation = (AssertFalse)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isFalse, null, null, assertFalseAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.AssertFalse assertFalseAnnotation = (javax.validation.constraints.AssertFalse)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isFalse, null, null, assertFalseAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForMinAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            jakarta.validation.constraints.Min minAnnotation = (jakarta.validation.constraints.Min)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isGreaterOrEqualNonDecimal, String.valueOf(minAnnotation.value()), null, minAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            Min minAnnotation = (Min)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isGreaterOrEqualNonDecimal, String.valueOf(minAnnotation.value()), null, minAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForMaxAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            Max maxAnnotation = (Max)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isLessOrEqualNonDecimal, null, String.valueOf(maxAnnotation.value()), maxAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.Max maxAnnotation = (javax.validation.constraints.Max)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isLessOrEqualNonDecimal, null, String.valueOf(maxAnnotation.value()), maxAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForDecimalMinAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            DecimalMin minDecimalAnnotation = (DecimalMin)this.annotation;
            if (minDecimalAnnotation.inclusive()) {
                return Optional.of(new AssertionModel(AssertionType.isGreaterOrEqual, minDecimalAnnotation.value(), null, minDecimalAnnotation.message()));
            }
            return Optional.of(new AssertionModel(AssertionType.isGreaterThan, minDecimalAnnotation.value(), null, minDecimalAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.DecimalMin minDecimalAnnotation = (javax.validation.constraints.DecimalMin)this.annotation;
            if (minDecimalAnnotation.inclusive()) {
                return Optional.of(new AssertionModel(AssertionType.isGreaterOrEqual, minDecimalAnnotation.value(), null, minDecimalAnnotation.message()));
            }
            return Optional.of(new AssertionModel(AssertionType.isGreaterThan, minDecimalAnnotation.value(), null, minDecimalAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForDecimalMaxAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            DecimalMax maxDecimalAnnotation = (DecimalMax)this.annotation;
            if (maxDecimalAnnotation.inclusive()) {
                return Optional.of(new AssertionModel(AssertionType.isLessOrEqual, null, maxDecimalAnnotation.value(), maxDecimalAnnotation.message()));
            }
            return Optional.of(new AssertionModel(AssertionType.isLessThan, null, maxDecimalAnnotation.value(), maxDecimalAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.DecimalMax maxDecimalAnnotation = (javax.validation.constraints.DecimalMax)this.annotation;
            if (maxDecimalAnnotation.inclusive()) {
                return Optional.of(new AssertionModel(AssertionType.isLessOrEqual, null, maxDecimalAnnotation.value(), maxDecimalAnnotation.message()));
            }
            return Optional.of(new AssertionModel(AssertionType.isLessThan, null, maxDecimalAnnotation.value(), maxDecimalAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForNegativeAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            jakarta.validation.constraints.Negative negativeAnnotation = (jakarta.validation.constraints.Negative)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isNegative, null, null, negativeAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            Negative negativeAnnotation = (Negative)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isNegative, null, null, negativeAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForNegativeOrZeroAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            jakarta.validation.constraints.NegativeOrZero negativeOrZeroAnnotation = (jakarta.validation.constraints.NegativeOrZero)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isNegativeOrZero, null, null, negativeOrZeroAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            NegativeOrZero negativeOrZeroAnnotation = (NegativeOrZero)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isNegativeOrZero, null, null, negativeOrZeroAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForPositiveAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            Positive positiveAnnotation = (Positive)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isPositive, null, null, positiveAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.Positive positiveAnnotation = (javax.validation.constraints.Positive)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isPositive, null, null, positiveAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForPositiveOrZeroAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            PositiveOrZero positiveOrZeroAnnotation = (PositiveOrZero)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isPositiveOrZero, null, null, positiveOrZeroAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.PositiveOrZero positiveOrZeroAnnotation = (javax.validation.constraints.PositiveOrZero)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isPositiveOrZero, null, null, positiveOrZeroAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForSizeAnnotation() {
        AssertionType assertionType = AssertionType.hasSize;
        if (this.annotatedType instanceof Class && CharSequence.class.isAssignableFrom((Class)this.annotatedType) && (!this.isCollection || this.contained)) {
            assertionType = AssertionType.hasLength;
        }
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            jakarta.validation.constraints.Size sizeAnnotation = (jakarta.validation.constraints.Size)this.annotation;
            return Optional.of(new AssertionModel(assertionType, String.valueOf(sizeAnnotation.min()), String.valueOf(sizeAnnotation.max()), sizeAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            Size sizeAnnotation = (Size)this.annotation;
            return Optional.of(new AssertionModel(assertionType, String.valueOf(sizeAnnotation.min()), String.valueOf(sizeAnnotation.max()), sizeAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForDigitsAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            jakarta.validation.constraints.Digits digitsAnnotation = (jakarta.validation.constraints.Digits)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.hasMaxDigits, String.valueOf(digitsAnnotation.integer()), String.valueOf(digitsAnnotation.fraction()), digitsAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            Digits digitsAnnotation = (Digits)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.hasMaxDigits, String.valueOf(digitsAnnotation.integer()), String.valueOf(digitsAnnotation.fraction()), digitsAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForPastAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            Past pastAnnotation = (Past)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isPast, null, null, pastAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.Past pastAnnotation = (javax.validation.constraints.Past)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isPast, null, null, pastAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForPastOrPresentAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            jakarta.validation.constraints.PastOrPresent pastOrPresentAnnotation = (jakarta.validation.constraints.PastOrPresent)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isPastOrPresent, null, null, pastOrPresentAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            PastOrPresent pastOrPresentAnnotation = (PastOrPresent)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isPastOrPresent, null, null, pastOrPresentAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForFutureAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            Future futureAnnotation = (Future)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isFuture, null, null, futureAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.Future futureAnnotation = (javax.validation.constraints.Future)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isFuture, null, null, futureAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForFutureOrPresentAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            jakarta.validation.constraints.FutureOrPresent futureOrPresentAnnotation = (jakarta.validation.constraints.FutureOrPresent)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isFutureOrPresent, null, null, futureOrPresentAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            FutureOrPresent futureOrPresentAnnotation = (FutureOrPresent)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isFutureOrPresent, null, null, futureOrPresentAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForPatternAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            Pattern patternAnnotation = (Pattern)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.regEx, patternAnnotation.regexp(), null, patternAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.Pattern patternAnnotation = (javax.validation.constraints.Pattern)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.regEx, patternAnnotation.regexp(), null, patternAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForNotEmptyAnnotation() {
        AssertionType assertionType = AssertionType.isNotEmptyIterable;
        if (this.annotatedType instanceof Class && CharSequence.class.isAssignableFrom((Class)this.annotatedType)) {
            assertionType = AssertionType.isNotEmpty;
        }
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            jakarta.validation.constraints.NotEmpty notEmptyAnnotation = (jakarta.validation.constraints.NotEmpty)this.annotation;
            return Optional.of(new AssertionModel(assertionType, null, null, notEmptyAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            NotEmpty notEmptyAnnotation = (NotEmpty)this.annotation;
            return Optional.of(new AssertionModel(assertionType, null, null, notEmptyAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForNotBlankAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            NotBlank notBlankAnnotation = (NotBlank)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isNotBlank, null, null, notBlankAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.NotBlank notBlankAnnotation = (javax.validation.constraints.NotBlank)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isNotBlank, null, null, notBlankAnnotation.message()));
        }
        return Optional.empty();
    }

    private Optional<AssertionMirror> buildAssertionMirrorForEmailAnnotation() {
        if (this.annotation.annotationType().getName().startsWith("jakarta.validation.constraints")) {
            Email emailAnnotation = (Email)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isValidEmail, null, null, emailAnnotation.message()));
        }
        if (this.annotation.annotationType().getName().startsWith("javax.validation.constraints")) {
            javax.validation.constraints.Email emailAnnotation = (javax.validation.constraints.Email)this.annotation;
            return Optional.of(new AssertionModel(AssertionType.isValidEmail, null, null, emailAnnotation.message()));
        }
        return Optional.empty();
    }

    private boolean isNullAnnotation() {
        return "Null".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isNotNullAnnotation() {
        return "NotNull".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isAssertTrueAnnotation() {
        return "AssertTrue".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isAssertFalseAnnotation() {
        return "AssertFalse".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isMinAnnotation() {
        return "Min".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isMaxAnnotation() {
        return "Max".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isDecimalMinAnnotation() {
        return "DecimalMin".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isDecimalMaxAnnotation() {
        return "DecimalMax".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isNegativeAnnotation() {
        return "Negative".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isNegativeOrZeroAnnotation() {
        return "NegativeOrZero".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isPositiveAnnotation() {
        return "Positive".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isPositiveOrZeroAnnotation() {
        return "PositiveOrZero".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isSizeAnnotation() {
        return "Size".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isDigitsAnnotation() {
        return "Digits".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isPastAnnotation() {
        return "Past".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isPastOrPresentAnnotation() {
        return "PastOrPresent".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isFutureAnnotation() {
        return "Future".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isFutureOrPresentAnnotation() {
        return "FutureOrPresent".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isPatternAnnotation() {
        return "Pattern".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isNotEmptyAnnotation() {
        return "NotEmpty".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isNotBlankAnnotation() {
        return "NotBlank".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private boolean isEmailAnnotation() {
        return "Email".equals(this.annotationIdentifier(this.annotation.annotationType()));
    }

    private String annotationIdentifier(Class<? extends Annotation> annotationType) {
        if ("javax.validation.constraints".equals(annotationType.getPackageName()) || "jakarta.validation.constraints".equals(annotationType.getPackageName())) {
            return annotationType.getSimpleName();
        }
        return null;
    }
}

