/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.domain.types.AggregateCommand;
import io.domainlifecycles.domain.types.AggregateRoot;
import io.domainlifecycles.domain.types.ApplicationService;
import io.domainlifecycles.domain.types.DomainCommand;
import io.domainlifecycles.domain.types.DomainEvent;
import io.domainlifecycles.domain.types.DomainService;
import io.domainlifecycles.domain.types.DomainServiceCommand;
import io.domainlifecycles.domain.types.Entity;
import io.domainlifecycles.domain.types.Identity;
import io.domainlifecycles.domain.types.OutboundService;
import io.domainlifecycles.domain.types.QueryHandler;
import io.domainlifecycles.domain.types.ReadModel;
import io.domainlifecycles.domain.types.Repository;
import io.domainlifecycles.domain.types.ServiceKind;
import io.domainlifecycles.domain.types.ValueObject;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import io.domainlifecycles.mirror.reflect.AggregateRootMirrorBuilder;
import io.domainlifecycles.mirror.reflect.ApplicationServiceMirrorBuilder;
import io.domainlifecycles.mirror.reflect.DomainCommandMirrorBuilder;
import io.domainlifecycles.mirror.reflect.DomainEventMirrorBuilder;
import io.domainlifecycles.mirror.reflect.DomainServiceMirrorBuilder;
import io.domainlifecycles.mirror.reflect.DomainTypeMirrorBuilder;
import io.domainlifecycles.mirror.reflect.EntityMirrorBuilder;
import io.domainlifecycles.mirror.reflect.EnumMirrorBuilder;
import io.domainlifecycles.mirror.reflect.IdentityMirrorBuilder;
import io.domainlifecycles.mirror.reflect.OutboundServiceMirrorBuilder;
import io.domainlifecycles.mirror.reflect.QueryHandlerMirrorBuilder;
import io.domainlifecycles.mirror.reflect.ReadModelMirrorBuilder;
import io.domainlifecycles.mirror.reflect.RepositoryMirrorBuilder;
import io.domainlifecycles.mirror.reflect.ServiceKindMirrorBuilder;
import io.domainlifecycles.mirror.reflect.ValueObjectMirrorBuilder;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassGraphDomainTypesScanner {
    private static final Logger log = LoggerFactory.getLogger(ClassGraphDomainTypesScanner.class);
    private final ClassLoader classLoader;
    private final GenericTypeResolver genericTypeResolver;

    public ClassGraphDomainTypesScanner(ClassLoader classLoader, GenericTypeResolver genericTypeResolver) {
        this.classLoader = Objects.requireNonNull(classLoader, "Please provide a ClassLoader.");
        this.genericTypeResolver = Objects.requireNonNull(genericTypeResolver, "A GenericTypeResolver must be provided!");
    }

    public ClassGraphDomainTypesScanner(GenericTypeResolver genericTypeResolver) {
        this.genericTypeResolver = Objects.requireNonNull(genericTypeResolver, "A GenericTypeResolver must be provided!");
        this.classLoader = null;
    }

    public List<DomainTypeMirror> scan(String ... packages) {
        ArrayList<DomainTypeMirror> domainTypes = new ArrayList<DomainTypeMirror>();
        if (packages.length > 0) {
            String packageNames = String.join((CharSequence)", ", packages);
            log.info("Scanning packages for domain types: {}", (Object)packageNames);
        }
        ClassGraph classGraph = new ClassGraph().enableAllInfo();
        if (packages.length > 0) {
            classGraph.acceptPackages(packages);
        }
        if (this.classLoader != null) {
            classGraph.addClassLoader(this.classLoader);
        }
        try (ScanResult scanResult = classGraph.scan();){
            scanResult.getAllEnums().stream().map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new EnumMirrorBuilder((Class<? extends Enum<?>>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(Identity.class).stream().filter(c -> !Identity.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new IdentityMirrorBuilder((Class<? extends Identity<?>>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(ValueObject.class).stream().filter(c -> !ValueObject.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new ValueObjectMirrorBuilder((Class<? extends ValueObject>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(Entity.class).filter(f -> !f.implementsInterface(AggregateRoot.class)).filter(c -> !Entity.class.getName().equals(c.getName())).filter(c -> !AggregateRoot.class.getName().equals(c.getName())).stream().map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> (EntityMirror)this.build(new EntityMirrorBuilder((Class<? extends Entity<?>>)((Class<Entity<?>>)dt), this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(AggregateRoot.class).stream().filter(c -> !AggregateRoot.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new AggregateRootMirrorBuilder((Class<? extends AggregateRoot<?>>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(DomainService.class).stream().filter(c -> !DomainService.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new DomainServiceMirrorBuilder((Class<? extends DomainService>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(ApplicationService.class).stream().filter(c -> !ApplicationService.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new ApplicationServiceMirrorBuilder((Class<? extends ApplicationService>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(DomainEvent.class).stream().filter(c -> !DomainEvent.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new DomainEventMirrorBuilder((Class<? extends DomainEvent>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(Repository.class).stream().filter(c -> !Repository.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new RepositoryMirrorBuilder((Class<? extends Repository<?, ?>>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(DomainCommand.class).stream().filter(c -> !DomainCommand.class.getName().equals(c.getName())).filter(c -> !AggregateCommand.class.getName().equals(c.getName())).filter(c -> !DomainServiceCommand.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new DomainCommandMirrorBuilder((Class<? extends DomainCommand>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(ReadModel.class).stream().filter(c -> !ReadModel.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new ReadModelMirrorBuilder((Class<? extends ReadModel>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(QueryHandler.class).stream().filter(c -> !QueryHandler.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new QueryHandlerMirrorBuilder((Class<? extends QueryHandler<?>>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(OutboundService.class).stream().filter(c -> !OutboundService.class.getName().equals(c.getName())).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> this.build(new OutboundServiceMirrorBuilder((Class<? extends OutboundService>)dt, this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
            scanResult.getClassesImplementing(ServiceKind.class).stream().filter(c -> !ServiceKind.class.getName().equals(c.getName()) && !ApplicationService.class.getName().equals(c.getName()) && !DomainService.class.getName().equals(c.getName()) && !OutboundService.class.getName().equals(c.getName()) && !QueryHandler.class.getName().equals(c.getName()) && !Repository.class.getName().equals(c.getName())).filter(c -> !c.implementsInterface(ApplicationService.class) && !c.implementsInterface(DomainService.class) && !c.implementsInterface(OutboundService.class) && !c.implementsInterface(QueryHandler.class) && !c.implementsInterface(Repository.class)).map(r -> this.loadClass((ClassInfo)r)).filter(Objects::nonNull).map(dt -> (ServiceKindMirror)this.build(new ServiceKindMirrorBuilder((Class<? extends ServiceKind>)((Class<ServiceKind>)((Class<? extends ServiceKind>)dt)), this.genericTypeResolver))).filter(Objects::nonNull).forEach(domainTypes::add);
        }
        catch (Throwable t) {
            log.error("Scanning packages '{}' failed!", (Object)packages, (Object)t);
        }
        return domainTypes;
    }

    private Class<?> loadClass(ClassInfo classInfo) {
        try {
            return classInfo.loadClass();
        }
        catch (Throwable t) {
            log.error("Loading class '{}' failed!", (Object)classInfo.getName(), (Object)t);
            return null;
        }
    }

    private <T extends DomainTypeMirror> T build(DomainTypeMirrorBuilder<T> builder) {
        try {
            return builder.build();
        }
        catch (Throwable t) {
            log.error("Building mirror failed! {}", (Object)builder.domainClass.getName(), (Object)t);
            return null;
        }
    }
}

