/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.domain.types.AggregateCommand;
import io.domainlifecycles.domain.types.DomainCommand;
import io.domainlifecycles.domain.types.DomainService;
import io.domainlifecycles.domain.types.DomainServiceCommand;
import io.domainlifecycles.domain.types.Identity;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.model.DomainCommandModel;
import io.domainlifecycles.mirror.reflect.DomainTypeMirrorBuilder;
import io.domainlifecycles.mirror.reflect.GenericInterfaceTypeResolver;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import java.util.Optional;

public class DomainCommandMirrorBuilder
extends DomainTypeMirrorBuilder<DomainCommandMirror> {
    private final Class<? extends DomainCommand> domainCommandClass;

    public DomainCommandMirrorBuilder(Class<? extends DomainCommand> domainCommandClass, GenericTypeResolver genericTypeResolver) {
        super(domainCommandClass, genericTypeResolver);
        this.domainCommandClass = domainCommandClass;
    }

    @Override
    public DomainCommandMirror build() {
        Optional<Class<?>> targetType = DomainCommandMirrorBuilder.getTargetType(this.domainCommandClass);
        String aggregateIdentityTargetTypeName = null;
        String domainServiceTargetTypeName = null;
        if (targetType.isPresent()) {
            if (DomainService.class.isAssignableFrom(targetType.get())) {
                domainServiceTargetTypeName = targetType.get().getName();
            } else if (Identity.class.isAssignableFrom(targetType.get())) {
                aggregateIdentityTargetTypeName = targetType.get().getName();
            }
        }
        return new DomainCommandModel(this.getTypeName(), this.isAbstract(), this.buildFields(), this.buildMethods(), Optional.ofNullable(aggregateIdentityTargetTypeName), Optional.ofNullable(domainServiceTargetTypeName), this.buildInheritanceHierarchy(), this.buildInterfaceTypes());
    }

    private static Optional<Class<?>> getTargetType(Class<? extends DomainCommand> c) {
        if (DomainServiceCommand.class.isAssignableFrom(c)) {
            GenericInterfaceTypeResolver resolver = new GenericInterfaceTypeResolver(c);
            Class<?> resolved = resolver.resolveFor(DomainServiceCommand.class, 0);
            return Optional.ofNullable(resolved);
        }
        if (AggregateCommand.class.isAssignableFrom(c)) {
            GenericInterfaceTypeResolver resolver = new GenericInterfaceTypeResolver(c);
            Class<?> resolved = resolver.resolveFor(AggregateCommand.class, 0);
            return Optional.ofNullable(resolved);
        }
        return Optional.empty();
    }
}

