/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.reflect.FieldMirrorBuilder;
import io.domainlifecycles.mirror.reflect.MethodMirrorBuilder;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import io.domainlifecycles.reflect.JavaReflect;
import io.domainlifecycles.reflect.MemberSelect;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DomainTypeMirrorBuilder<T extends DomainTypeMirror> {
    private static final Logger log = LoggerFactory.getLogger(DomainTypeMirrorBuilder.class);
    protected final Class<?> domainClass;
    protected final List<Field> fields;
    protected final GenericTypeResolver genericTypeResolver;

    public abstract T build();

    public DomainTypeMirrorBuilder(Class<?> domainClass, GenericTypeResolver genericTypeResolver) {
        this.domainClass = domainClass;
        this.genericTypeResolver = genericTypeResolver;
        List theFields = Collections.emptyList();
        try {
            theFields = JavaReflect.fields(domainClass, (MemberSelect)MemberSelect.HIERARCHY);
        }
        catch (Throwable t) {
            log.error("Accessing fields for {} failed!", (Object)domainClass.getName(), (Object)t);
        }
        this.fields = theFields;
    }

    protected List<FieldMirror> buildFields() {
        return this.fields.stream().filter(f -> !f.isSynthetic()).map(f -> {
            try {
                return new FieldMirrorBuilder((Field)f, this.domainClass, this.isHidden((Field)f), this.genericTypeResolver).build();
            }
            catch (Throwable t) {
                log.error("Building FieldMirror failed {}.{}", new Object[]{this.domainClass.getName(), f.getName(), t});
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    protected boolean isHidden(Field f) {
        return this.fields.stream().anyMatch(c -> this.isHiddenBy(f, (Field)c));
    }

    private boolean isHiddenBy(Field f, Field candidate) {
        if (f.equals(candidate) || !f.getDeclaringClass().isAssignableFrom(candidate.getDeclaringClass())) {
            return false;
        }
        return f.getName().equals(candidate.getName());
    }

    protected List<MethodMirror> buildMethods() {
        List meth = JavaReflect.methods(this.domainClass, (MemberSelect)MemberSelect.HIERARCHY);
        return meth.stream().filter(m -> !m.isSynthetic() && !m.isBridge()).map(m -> {
            try {
                return new MethodMirrorBuilder((Method)m, this.domainClass, this.isOverridden((Method)m, meth), this.genericTypeResolver).build();
            }
            catch (Throwable t) {
                log.error("Building MethodMirror failed {}.{}", new Object[]{this.domainClass.getName(), m.getName(), t});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean isOverridden(Method m, List<Method> candidates) {
        return candidates.stream().anyMatch(c -> this.isOverriddenBy(m, (Method)c));
    }

    private boolean isOverriddenBy(Method m, Method candidate) {
        Class<?>[] superclassParamTypes;
        if (m.equals(candidate) || !m.getDeclaringClass().isAssignableFrom(candidate.getDeclaringClass())) {
            return false;
        }
        if (!m.getName().equals(candidate.getName())) {
            return false;
        }
        if (!candidate.getReturnType().equals(m.getReturnType())) {
            return false;
        }
        if (!this.candidateIsAsOrLessRestrictive(m, candidate)) {
            return false;
        }
        Class<?>[] subclassParamTypes = m.getParameterTypes();
        if (subclassParamTypes.length != (superclassParamTypes = candidate.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < subclassParamTypes.length; ++i) {
            if (subclassParamTypes[i].equals(superclassParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean candidateIsAsOrLessRestrictive(Method m, Method candidate) {
        int superclassModifiers;
        int subclassModifiers = m.getModifiers();
        return subclassModifiers <= (superclassModifiers = candidate.getModifiers());
    }

    protected List<String> buildInheritanceHierarchy() {
        Class<?> superClass = this.domainClass.getSuperclass();
        ArrayList<String> hierarchy = new ArrayList<String>();
        if (superClass != null) {
            hierarchy.add(superClass.getName());
            while (superClass != null && !superClass.getName().equals(Object.class.getName())) {
                if ((superClass = superClass.getSuperclass()) == null) continue;
                hierarchy.add(superClass.getName());
            }
        }
        return hierarchy;
    }

    protected List<String> buildInterfaceTypes() {
        return Arrays.stream(this.domainClass.getInterfaces()).map(Class::getName).toList();
    }

    protected String getTypeName() {
        return this.domainClass.getName();
    }

    protected boolean isAbstract() {
        return JavaReflect.isAbstract(this.domainClass);
    }
}

