/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.domain.types.Entity;
import io.domainlifecycles.domain.types.Identity;
import io.domainlifecycles.domain.types.internal.ConcurrencySafe;
import io.domainlifecycles.mirror.api.EntityMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.model.EntityModel;
import io.domainlifecycles.mirror.reflect.DomainTypeMirrorBuilder;
import io.domainlifecycles.mirror.reflect.FieldMirrorBuilder;
import io.domainlifecycles.mirror.reflect.GenericInterfaceTypeResolver;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import io.domainlifecycles.reflect.JavaReflect;
import io.domainlifecycles.reflect.MemberSelect;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;

public class EntityMirrorBuilder<T extends EntityMirror>
extends DomainTypeMirrorBuilder<T> {
    private final Class<? extends Entity<?>> entityClass;

    public EntityMirrorBuilder(Class<? extends Entity<?>> entityClass, GenericTypeResolver genericTypeResolver) {
        super(entityClass, genericTypeResolver);
        this.entityClass = entityClass;
    }

    @Override
    public T build() {
        return (T)new EntityModel(this.getTypeName(), this.isAbstract(), this.buildFields(), this.buildMethods(), this.identityField(), this.concurrencyVersionField(), this.buildInheritanceHierarchy(), this.buildInterfaceTypes());
    }

    protected Optional<FieldMirror> identityField() {
        List<Field> idPropertyFieldCandidates;
        Optional<Object> idProperty;
        Optional<Class<Identity<?>>> identityType = EntityMirrorBuilder.getIdentityType(this.entityClass);
        if (identityType.isPresent() && (idProperty = (idPropertyFieldCandidates = JavaReflect.fields(this.entityClass, (MemberSelect)MemberSelect.HIERARCHY).stream().filter(f -> ((Class)identityType.get()).isAssignableFrom(f.getType()) || Identity.class.getName().equals(f.getType().getName())).toList()).size() > 1 ? idPropertyFieldCandidates.stream().filter(f -> f.isAnnotationPresent(Entity.Id.class)).findFirst() : idPropertyFieldCandidates.stream().findFirst()).isPresent()) {
            return Optional.of(new FieldMirrorBuilder((Field)idProperty.get(), this.entityClass, this.isHidden((Field)idProperty.get()), this.genericTypeResolver).build());
        }
        return Optional.empty();
    }

    protected Optional<FieldMirror> concurrencyVersionField() {
        List<Field> concurrencyFieldCandidates = JavaReflect.fields(this.entityClass, (MemberSelect)MemberSelect.HIERARCHY).stream().filter(f -> f.isAnnotationPresent(ConcurrencySafe.ConcurrencyVersion.class)).toList();
        if (concurrencyFieldCandidates.size() == 1) {
            Field concurrencyField = concurrencyFieldCandidates.get(0);
            return Optional.of(new FieldMirrorBuilder(concurrencyField, this.entityClass, this.isHidden(concurrencyField), this.genericTypeResolver).build());
        }
        return Optional.empty();
    }

    private static Optional<Class<? extends Identity<?>>> getIdentityType(Class<? extends Entity<? extends Identity<?>>> c) {
        GenericInterfaceTypeResolver resolver = new GenericInterfaceTypeResolver(c);
        Class<?> resolved = resolver.resolveFor(Entity.class, 0);
        return Optional.ofNullable(resolved);
    }
}

