/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.mirror.api.EnumMirror;
import io.domainlifecycles.mirror.api.EnumOptionMirror;
import io.domainlifecycles.mirror.model.EnumModel;
import io.domainlifecycles.mirror.model.EnumOptionModel;
import io.domainlifecycles.mirror.reflect.DomainTypeMirrorBuilder;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class EnumMirrorBuilder
extends DomainTypeMirrorBuilder<EnumMirror> {
    private final Class<? extends Enum<?>> enumClass;

    public EnumMirrorBuilder(Class<? extends Enum<?>> enumClass, GenericTypeResolver genericTypeResolver) {
        super(enumClass, genericTypeResolver);
        this.enumClass = enumClass;
    }

    @Override
    public EnumMirror build() {
        return new EnumModel(this.getTypeName(), this.isAbstract(), this.buildFields(), this.buildMethods(), this.buildEnumOptions(), this.buildInheritanceHierarchy(), this.buildInterfaceTypes());
    }

    private List<EnumOptionMirror> buildEnumOptions() {
        if (this.enumClass.getEnumConstants() != null) {
            return Arrays.stream(this.enumClass.getEnumConstants()).map(c -> new EnumOptionModel(c.name())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

