/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.mirror.api.AccessLevel;
import io.domainlifecycles.mirror.api.AssertedContainableTypeMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.model.AggregateRootReferenceModel;
import io.domainlifecycles.mirror.model.EntityReferenceModel;
import io.domainlifecycles.mirror.model.FieldModel;
import io.domainlifecycles.mirror.model.ValueReferenceModel;
import io.domainlifecycles.mirror.reflect.AssertedContainableTypeMirrorBuilder;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import io.domainlifecycles.reflect.JavaReflect;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class FieldMirrorBuilder {
    private final Field field;
    private final GenericTypeResolver genericTypeResolver;
    private final Class<?> topLevelClass;
    private final AssertedContainableTypeMirrorBuilder typeMirrorBuilder;
    private final boolean hidden;
    private static final String GETTER_PREFIX = "get";
    private static final String BOOL_GETTER_PREFIX = "is";
    private static final String SETTER_PREFIX = "set";

    public FieldMirrorBuilder(Field field, Class<?> topLevelClass, boolean hidden, GenericTypeResolver genericTypeResolver) {
        this.field = field;
        this.topLevelClass = Objects.requireNonNull(topLevelClass, "The corresponding top level class cannot be null!");
        this.genericTypeResolver = genericTypeResolver;
        this.typeMirrorBuilder = new AssertedContainableTypeMirrorBuilder(field.getType(), field.getAnnotatedType(), field.getGenericType(), genericTypeResolver.resolveFieldType(field, topLevelClass));
        this.hidden = hidden;
    }

    private boolean isPublicReadable() {
        if (JavaReflect.isPublic((Member)this.field)) {
            return true;
        }
        Method mGetter = null;
        Method mBoolGetter = null;
        Method mReader = null;
        String upperFirst = this.field.getName().substring(0, 1).toUpperCase() + this.field.getName().substring(1);
        try {
            mGetter = this.field.getDeclaringClass().getMethod(GETTER_PREFIX + upperFirst, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            mBoolGetter = this.field.getDeclaringClass().getMethod(BOOL_GETTER_PREFIX + upperFirst, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            mReader = this.field.getDeclaringClass().getMethod(this.field.getName(), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return mGetter != null && Modifier.isPublic(mGetter.getModifiers()) && mGetter.getParameterCount() == 0 && mGetter.getReturnType().equals(this.field.getType()) || mBoolGetter != null && Modifier.isPublic(mBoolGetter.getModifiers()) && mBoolGetter.getParameterCount() == 0 && mBoolGetter.getReturnType().equals(this.field.getType()) || mReader != null && Modifier.isPublic(mReader.getModifiers()) && mReader.getParameterCount() == 0 && mReader.getReturnType().equals(this.field.getType());
    }

    private boolean isPublicWriteable() {
        if (JavaReflect.isFinal((Member)this.field)) {
            return false;
        }
        if (JavaReflect.isPublic((Member)this.field)) {
            return true;
        }
        Method mSetter = null;
        Method mWriter = null;
        String upperFirst = this.field.getName().substring(0, 1).toUpperCase() + this.field.getName().substring(1);
        try {
            mSetter = this.field.getDeclaringClass().getMethod(SETTER_PREFIX + upperFirst, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            mWriter = this.field.getDeclaringClass().getMethod(this.field.getName(), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return mSetter != null && Modifier.isPublic(mSetter.getModifiers()) && mSetter.getParameterCount() == 1 && mSetter.getReturnType().equals(Void.TYPE) && mSetter.getParameterTypes()[0].equals(this.typeMirrorBuilder.getBasicType()) || mWriter != null && Modifier.isPublic(mWriter.getModifiers()) && mWriter.getParameterCount() == 1 && mWriter.getReturnType().equals(Void.TYPE) && mWriter.getParameterTypes()[0].equals(this.typeMirrorBuilder.getBasicType());
    }

    public FieldMirror build() {
        String name = this.field.getName();
        String declaredByTypeName = this.field.getDeclaringClass().getName();
        boolean isModifiable = !JavaReflect.isFinal((Member)this.field);
        boolean isPublicReadable = this.isPublicReadable();
        boolean isPublicWriteable = this.isPublicWriteable();
        AssertedContainableTypeMirror typeMirror = this.typeMirrorBuilder.build();
        AccessLevel accessLevel = AccessLevel.of(this.field);
        boolean isStatic = JavaReflect.isStatic((Member)this.field);
        if (DomainType.ENTITY.equals((Object)typeMirror.getDomainType())) {
            return new EntityReferenceModel(name, typeMirror, accessLevel, declaredByTypeName, isModifiable, isPublicReadable, isPublicWriteable, isStatic, this.hidden);
        }
        if (DomainType.VALUE_OBJECT.equals((Object)typeMirror.getDomainType()) || DomainType.ENUM.equals((Object)typeMirror.getDomainType()) || DomainType.IDENTITY.equals((Object)typeMirror.getDomainType())) {
            return new ValueReferenceModel(name, typeMirror, accessLevel, declaredByTypeName, isModifiable, isPublicReadable, isPublicWriteable, isStatic, this.hidden);
        }
        if (DomainType.AGGREGATE_ROOT.equals((Object)typeMirror.getDomainType())) {
            return new AggregateRootReferenceModel(name, typeMirror, accessLevel, declaredByTypeName, isModifiable, isPublicReadable, isPublicWriteable, isStatic, this.hidden);
        }
        return new FieldModel(name, typeMirror, accessLevel, declaredByTypeName, isModifiable, isPublicReadable, isPublicWriteable, isStatic, this.hidden);
    }
}

