/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.mirror.exception.MirrorException;
import io.domainlifecycles.reflect.JavaReflect;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GenericInterfaceTypeResolver {
    private final Class<?> subType;
    private final List<Class<?>> hierarchy;

    public GenericInterfaceTypeResolver(Class<?> subType) {
        this.subType = subType;
        this.hierarchy = JavaReflect.allSupertypes(subType);
    }

    public Class<?> resolveFor(Class<?> interfaceType, int parameterIndex) {
        if (!interfaceType.isInterface()) {
            throw MirrorException.fail("Tried to resolve generic type parameter for non interface type %s", interfaceType.getName());
        }
        if (!JavaReflect.isGeneric(interfaceType)) {
            throw MirrorException.fail("Tried to resolve generic type parameter for non generic interface type %s", interfaceType.getName());
        }
        if (interfaceType.getTypeParameters().length <= parameterIndex) {
            throw MirrorException.fail("Generic interface type %s has less than %s parameters", interfaceType.getName(), parameterIndex + 1);
        }
        LinkedList<Class> filteredTypeHierarchy = new LinkedList<Class>(this.hierarchy.stream().filter(c -> interfaceType.isAssignableFrom((Class<?>)c)).toList());
        TypeVariable<Class<?>> variable = interfaceType.getTypeParameters()[parameterIndex];
        Iterator<Class<?>> hierarchyIterator = filteredTypeHierarchy.descendingIterator();
        Class<?> superElement = hierarchyIterator.next();
        while (!superElement.getName().equals(interfaceType.getName()) && hierarchyIterator.hasNext()) {
            superElement = hierarchyIterator.next();
        }
        Class<?> subElement = this.subElement(hierarchyIterator);
        Type resolved = this.resolveActualTypeByVariableName(subElement, variable, superElement);
        while (resolved instanceof TypeVariable) {
            superElement = subElement;
            subElement = this.subElement(hierarchyIterator);
            if (subElement.equals(superElement)) break;
            resolved = this.resolveActualTypeByVariableName(subElement, (TypeVariable)resolved, superElement);
        }
        if (resolved instanceof Class) {
            return (Class)resolved;
        }
        if (resolved instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)resolved;
            if (tv.getBounds()[0] instanceof ParameterizedType) {
                ParameterizedType param = (ParameterizedType)tv.getBounds()[0];
                return (Class)param.getRawType();
            }
            return (Class)tv.getBounds()[0];
        }
        return null;
    }

    private Class<?> subElement(Iterator<Class<?>> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return this.subType;
    }

    private int implementsDirectlyIndex(Class<?> subType, Class<?> interfaceType) {
        Class<?>[] implementingInterfaces = subType.getInterfaces();
        for (int i = 0; i < implementingInterfaces.length; ++i) {
            if (!implementingInterfaces[i].getName().equals(interfaceType.getName())) continue;
            return i;
        }
        return -1;
    }

    private Type resolveActualTypeByVariableName(Class<?> subType, TypeVariable<?> variable, Class<?> superType) {
        if (superType.isInterface()) {
            int interfaceIndex = this.implementsDirectlyIndex(subType, superType);
            if (interfaceIndex < 0) {
                return variable;
            }
            Type genericInterface = subType.getGenericInterfaces()[interfaceIndex];
            if (genericInterface instanceof ParameterizedType) {
                int variableIndex = this.resolveVariableIndexByName(superType, variable.getName());
                return ((ParameterizedType)genericInterface).getActualTypeArguments()[variableIndex];
            }
        } else {
            Type genericSuperClass = subType.getGenericSuperclass();
            if (genericSuperClass instanceof ParameterizedType) {
                int variableIndex = this.resolveVariableIndexByName(superType, variable.getName());
                return ((ParameterizedType)genericSuperClass).getActualTypeArguments()[variableIndex];
            }
        }
        return variable;
    }

    private int resolveVariableIndexByName(Class<?> genericType, String variableName) {
        TypeVariable<Class<?>>[] params = genericType.getTypeParameters();
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].getName().equals(variableName)) continue;
            return i;
        }
        return -1;
    }
}

