/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.domain.types.Identity;
import io.domainlifecycles.mirror.api.IdentityMirror;
import io.domainlifecycles.mirror.model.IdentityModel;
import io.domainlifecycles.mirror.reflect.DomainTypeMirrorBuilder;
import io.domainlifecycles.mirror.reflect.GenericInterfaceTypeResolver;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import java.util.Optional;

public class IdentityMirrorBuilder
extends DomainTypeMirrorBuilder<IdentityMirror> {
    private final Class<? extends Identity<?>> identityClass;

    public IdentityMirrorBuilder(Class<? extends Identity<?>> identityClass, GenericTypeResolver genericTypeResolver) {
        super(identityClass, genericTypeResolver);
        this.identityClass = identityClass;
    }

    @Override
    public IdentityMirror build() {
        return new IdentityModel(this.getTypeName(), this.isAbstract(), this.buildFields(), this.buildMethods(), this.idValueType(), this.buildInheritanceHierarchy(), this.buildInterfaceTypes());
    }

    private Optional<String> idValueType() {
        return IdentityMirrorBuilder.getValueType(this.identityClass).map(Class::getName);
    }

    private static Optional<Class<?>> getValueType(Class<? extends Identity<?>> c) {
        GenericInterfaceTypeResolver resolver = new GenericInterfaceTypeResolver(c);
        Class<?> resolved = resolver.resolveFor(Identity.class, 0);
        return Optional.ofNullable(resolved);
    }
}

