/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.domain.types.ListensTo;
import io.domainlifecycles.domain.types.Publishes;
import io.domainlifecycles.mirror.api.AccessLevel;
import io.domainlifecycles.mirror.api.AssertedContainableTypeMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.ParamMirror;
import io.domainlifecycles.mirror.api.ResolvedGenericTypeMirror;
import io.domainlifecycles.mirror.model.MethodModel;
import io.domainlifecycles.mirror.model.ParamModel;
import io.domainlifecycles.mirror.reflect.AssertedContainableTypeMirrorBuilder;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MethodMirrorBuilder {
    private final Method m;
    private final Class<?> topLevelClass;
    private final boolean overridden;
    private final GenericTypeResolver genericTypeResolver;

    public MethodMirrorBuilder(Method m, Class<?> topLevelClass, boolean overridden, GenericTypeResolver genericTypeResolver) {
        this.m = Objects.requireNonNull(m);
        this.topLevelClass = Objects.requireNonNull(topLevelClass, "The corresponding top level class cannot be null!");
        this.overridden = overridden;
        this.genericTypeResolver = Objects.requireNonNull(genericTypeResolver, "The generic type resolver cannot be null!");
    }

    public MethodMirror build() {
        return new MethodModel(this.m.getName(), this.m.getDeclaringClass().getName(), AccessLevel.of(this.m), this.getParameters(), this.getReturnType(), this.overridden, this.publishedEventTypeNames(), this.listenedEventTypeName());
    }

    private AssertedContainableTypeMirror getReturnType() {
        AssertedContainableTypeMirrorBuilder builder = new AssertedContainableTypeMirrorBuilder(this.m.getReturnType(), this.m.getAnnotatedReturnType(), this.m.getGenericReturnType(), this.genericTypeResolver.resolveExecutableReturnType(this.m, this.topLevelClass));
        return builder.build();
    }

    private List<ParamMirror> getParameters() {
        List<ResolvedGenericTypeMirror> resolvedParameters = this.genericTypeResolver.resolveExecutableParameters(this.m, this.topLevelClass);
        ArrayList<ParamMirror> mirroredParams = new ArrayList<ParamMirror>();
        int i = 0;
        for (Parameter p : this.m.getParameters()) {
            ResolvedGenericTypeMirror resolved = null;
            if (resolvedParameters != null) {
                resolved = resolvedParameters.get(i);
            }
            AssertedContainableTypeMirrorBuilder typeMirrorBuilder = new AssertedContainableTypeMirrorBuilder(p.getType(), p.getAnnotatedType(), p.getParameterizedType(), resolved);
            mirroredParams.add(new ParamModel(p.getName(), typeMirrorBuilder.build()));
            ++i;
        }
        return mirroredParams;
    }

    private List<String> publishedEventTypeNames() {
        Publishes publishesAnnotation = this.m.getAnnotation(Publishes.class);
        if (publishesAnnotation != null && publishesAnnotation.domainEventTypes() != null) {
            return Arrays.stream(publishesAnnotation.domainEventTypes()).map(Class::getName).toList();
        }
        return Collections.emptyList();
    }

    private Optional<String> listenedEventTypeName() {
        ListensTo listensAnnotation = this.m.getAnnotation(ListensTo.class);
        if (listensAnnotation != null && listensAnnotation.domainEventType() != null) {
            return Optional.of(listensAnnotation.domainEventType().getName());
        }
        return Optional.empty();
    }
}

