/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainMirrorFactory;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import io.domainlifecycles.mirror.model.DomainModel;
import io.domainlifecycles.mirror.reflect.ClassGraphDomainTypesScanner;
import io.domainlifecycles.mirror.resolver.DefaultEmptyGenericTypeResolver;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import io.domainlifecycles.mirror.validate.CompletenessChecker;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectiveDomainMirrorFactory
implements DomainMirrorFactory {
    private static final Logger log = LoggerFactory.getLogger(ReflectiveDomainMirrorFactory.class);
    private final String[] domainModelPackages;
    private ClassGraphDomainTypesScanner classGraphDomainTypesScanner;
    private String[] boundedContextPackages;
    private GenericTypeResolver genericTypeResolver;
    private ClassLoader externalClassLoader;
    private static final Pattern packagePattern = Pattern.compile("^[a-z]+(\\.[a-zA-Z_][a-zA-Z0-9_]*)*$");

    public ReflectiveDomainMirrorFactory(String ... domainModelPackages) {
        this.domainModelPackages = domainModelPackages;
        if (domainModelPackages == null || domainModelPackages.length == 0) {
            throw MirrorException.fail("No domain model package defined!");
        }
        ReflectiveDomainMirrorFactory.validatePackages(domainModelPackages);
    }

    @Override
    public DomainMirror initializeDomainMirror() {
        this.initializeForScanning();
        String[] domainModelPackagesExtended = Arrays.copyOf(this.domainModelPackages, this.domainModelPackages.length + 1);
        domainModelPackagesExtended[this.domainModelPackages.length] = "io.domainlifecycles";
        Map builtTypeMirrors = this.classGraphDomainTypesScanner.scan(domainModelPackagesExtended).stream().collect(Collectors.toMap(DomainTypeMirror::getTypeName, Function.identity()));
        builtTypeMirrors.values().forEach(m -> log.debug("Created Mirror:" + String.valueOf(m)));
        DomainModel dm = new DomainModel(builtTypeMirrors, this.boundedContextPackages);
        CompletenessChecker c = new CompletenessChecker(dm);
        c.checkForCompleteness();
        return dm;
    }

    private void initializeForScanning() {
        if (this.genericTypeResolver == null) {
            this.genericTypeResolver = new DefaultEmptyGenericTypeResolver();
        }
        this.classGraphDomainTypesScanner = this.externalClassLoader == null ? new ClassGraphDomainTypesScanner(this.genericTypeResolver) : new ClassGraphDomainTypesScanner(this.externalClassLoader, this.genericTypeResolver);
        if (this.boundedContextPackages == null) {
            this.boundedContextPackages = this.domainModelPackages;
        }
        ReflectiveDomainMirrorFactory.validatePackages(this.boundedContextPackages);
    }

    private static void validatePackages(String ... packageNames) {
        for (String packageName : packageNames) {
            if (packagePattern.matcher(packageName).matches()) continue;
            throw MirrorException.fail("Invalid package name: " + packageName);
        }
    }

    public void setBoundedContextPackages(String[] boundedContextPackages) {
        this.boundedContextPackages = boundedContextPackages;
    }

    public void setGenericTypeResolver(GenericTypeResolver genericTypeResolver) {
        this.genericTypeResolver = genericTypeResolver;
    }

    public void setExternalClassLoader(ClassLoader externalClassLoader) {
        this.externalClassLoader = externalClassLoader;
    }
}

