/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.reflect;

import io.domainlifecycles.domain.types.AggregateRoot;
import io.domainlifecycles.domain.types.Repository;
import io.domainlifecycles.domain.types.ServiceKind;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.model.RepositoryModel;
import io.domainlifecycles.mirror.reflect.GenericInterfaceTypeResolver;
import io.domainlifecycles.mirror.reflect.ServiceKindMirrorBuilder;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class RepositoryMirrorBuilder
extends ServiceKindMirrorBuilder<RepositoryMirror> {
    private final Class<? extends Repository<?, ?>> repositoryClass;

    public RepositoryMirrorBuilder(Class<? extends Repository<?, ?>> repositoryClass, GenericTypeResolver genericTypeResolver) {
        super((Class<? extends ServiceKind>)repositoryClass, genericTypeResolver);
        this.repositoryClass = repositoryClass;
    }

    @Override
    public RepositoryMirror build() {
        return new RepositoryModel(this.getTypeName(), this.isAbstract(), this.buildFields(), this.buildMethods(), RepositoryMirrorBuilder.getManagedAggregateType(this.repositoryClass).map(Class::getName).orElse(Object.class.getName()), this.repositoryInterfaceTypeNames(), this.buildInheritanceHierarchy(), this.buildInterfaceTypes());
    }

    private static Optional<Class<? extends AggregateRoot<?>>> getManagedAggregateType(Class<? extends Repository<?, ?>> c) {
        GenericInterfaceTypeResolver resolver = new GenericInterfaceTypeResolver(c);
        Class<?> resolved = resolver.resolveFor(Repository.class, 1);
        return Optional.ofNullable(resolved);
    }

    private List<String> repositoryInterfaceTypeNames() {
        return Arrays.stream(this.repositoryClass.getInterfaces()).filter(i -> Repository.class.isAssignableFrom((Class<?>)i) && !i.getName().equals(Repository.class.getName())).map(Class::getName).toList();
    }
}

