/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.resolver;

import com.github.vladislavsevruk.resolver.resolver.executable.ExecutableTypeMetaResolver;
import com.github.vladislavsevruk.resolver.resolver.executable.ExecutableTypeResolver;
import com.github.vladislavsevruk.resolver.resolver.field.FieldTypeMetaResolver;
import com.github.vladislavsevruk.resolver.resolver.field.FieldTypeResolver;
import com.github.vladislavsevruk.resolver.type.TypeMeta;
import io.domainlifecycles.mirror.api.ResolvedGenericTypeMirror;
import io.domainlifecycles.mirror.api.WildcardBound;
import io.domainlifecycles.mirror.model.ResolvedGenericTypeModel;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class TypeMetaResolver
implements GenericTypeResolver {
    private final FieldTypeResolver<TypeMeta<?>> fieldTypeResolver = new FieldTypeMetaResolver();
    ExecutableTypeResolver<TypeMeta<?>> executableTypeResolver = new ExecutableTypeMetaResolver();

    @Override
    public ResolvedGenericTypeMirror resolveFieldType(Field f, Class<?> contextClass) {
        TypeMeta fieldTypeMeta = (TypeMeta)this.fieldTypeResolver.resolveField(contextClass, f);
        return this.map(fieldTypeMeta);
    }

    @Override
    public List<ResolvedGenericTypeMirror> resolveExecutableParameters(Method m, Class<?> contextClass) {
        return this.executableTypeResolver.getParameterTypes(contextClass, (Executable)m).stream().map(this::map).toList();
    }

    @Override
    public ResolvedGenericTypeMirror resolveExecutableReturnType(Method m, Class<?> contextClass) {
        TypeMeta methodReturnTypeMeta = (TypeMeta)this.executableTypeResolver.getReturnType(contextClass, (Executable)m);
        return this.map(methodReturnTypeMeta);
    }

    private ResolvedGenericTypeMirror map(TypeMeta<?> typeMeta) {
        String typeName = typeMeta.getType().getName();
        if (typeMeta.getType().isArray()) {
            typeName = typeMeta.getType().getComponentType().getName();
        }
        return new ResolvedGenericTypeModel(typeName, typeMeta.getType().isArray(), Arrays.stream(typeMeta.getGenericTypes()).map((? super T tm) -> this.map((TypeMeta<?>)tm)).toList(), this.map(typeMeta.getWildcardBound()));
    }

    private Optional<WildcardBound> map(com.github.vladislavsevruk.resolver.type.WildcardBound metaWildcardBound) {
        if (metaWildcardBound == null) {
            return Optional.empty();
        }
        return metaWildcardBound.equals((Object)com.github.vladislavsevruk.resolver.type.WildcardBound.UPPER) ? Optional.of(WildcardBound.UPPER) : Optional.of(WildcardBound.LOWER);
    }
}

