/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.serialize.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.domainlifecycles.mirror.api.AssertedContainableTypeMirror;
import io.domainlifecycles.mirror.api.AssertionMirror;
import io.domainlifecycles.mirror.api.BoundedContextMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EnumOptionMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.ParamMirror;
import io.domainlifecycles.mirror.api.ResolvedGenericTypeMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import io.domainlifecycles.mirror.serialize.api.AssertedContainableTypeMirrorMixin;
import io.domainlifecycles.mirror.serialize.api.AssertionMirrorMixin;
import io.domainlifecycles.mirror.serialize.api.BoundedContextMirrorMixin;
import io.domainlifecycles.mirror.serialize.api.DomainMirrorMixin;
import io.domainlifecycles.mirror.serialize.api.DomainSerializer;
import io.domainlifecycles.mirror.serialize.api.DomainTypeMirrorMixin;
import io.domainlifecycles.mirror.serialize.api.EnumOptionMirrorMixin;
import io.domainlifecycles.mirror.serialize.api.FieldMirrorMixin;
import io.domainlifecycles.mirror.serialize.api.MethodMirrorMixin;
import io.domainlifecycles.mirror.serialize.api.ParamMirrorMixin;
import io.domainlifecycles.mirror.serialize.api.ResolvedGenericTypeMirrorMixin;

public class JacksonDomainSerializer
implements DomainSerializer {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JacksonDomainSerializer(boolean prettyPrint) {
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.registerModule((Module)new ParameterNamesModule());
        this.objectMapper.addMixIn(ResolvedGenericTypeMirror.class, ResolvedGenericTypeMirrorMixin.class);
        this.objectMapper.addMixIn(DomainTypeMirror.class, DomainTypeMirrorMixin.class);
        this.objectMapper.addMixIn(FieldMirror.class, FieldMirrorMixin.class);
        this.objectMapper.addMixIn(AssertedContainableTypeMirror.class, AssertedContainableTypeMirrorMixin.class);
        this.objectMapper.addMixIn(MethodMirror.class, MethodMirrorMixin.class);
        this.objectMapper.addMixIn(ParamMirror.class, ParamMirrorMixin.class);
        this.objectMapper.addMixIn(EnumOptionMirror.class, EnumOptionMirrorMixin.class);
        this.objectMapper.addMixIn(AssertionMirror.class, AssertionMirrorMixin.class);
        this.objectMapper.addMixIn(BoundedContextMirror.class, BoundedContextMirrorMixin.class);
        this.objectMapper.addMixIn(DomainMirror.class, DomainMirrorMixin.class);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (prettyPrint) {
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
    }

    @Override
    public String serialize(DomainMirror domainMirror) {
        try {
            return this.objectMapper.writeValueAsString((Object)domainMirror);
        }
        catch (JsonProcessingException e) {
            throw MirrorException.fail("Jackson serialization failed!", e);
        }
    }

    @Override
    public DomainMirror deserialize(String serializedDomain) {
        try {
            DomainMirror dm = (DomainMirror)this.objectMapper.readValue(serializedDomain, DomainMirror.class);
            return dm;
        }
        catch (JsonProcessingException e) {
            throw MirrorException.fail("Jackson deserialization failed!", e);
        }
    }

    public <T extends DomainTypeMirror> T deserializeTypeMirror(String serializedTypeMirror) {
        try {
            DomainTypeMirror dm = (DomainTypeMirror)this.objectMapper.readValue(serializedTypeMirror, DomainTypeMirror.class);
            return (T)dm;
        }
        catch (JsonProcessingException e) {
            throw MirrorException.fail("Jackson deserialization failed!", e);
        }
    }
}

