/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.validate;

import io.domainlifecycles.mirror.api.AssertedContainableTypeMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.ParamMirror;
import io.domainlifecycles.mirror.exception.MirrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CompletenessChecker {
    private final List<String> messages = new ArrayList<String>();
    private final DomainMirror domainMirror;

    public CompletenessChecker(DomainMirror domainMirror) {
        this.domainMirror = Objects.requireNonNull(domainMirror, "A DomainMirror instance must be provided to be checked!");
    }

    public void checkForCompleteness() {
        this.domainMirror.getAllDomainTypeMirrors().stream().filter(t -> !t.getTypeName().startsWith("io.domainlifecycles.")).forEach(this::checkMirror);
        if (!this.messages.isEmpty()) {
            throw MirrorException.fail("Domain Model is not complete: \n%s", String.join((CharSequence)",\n", this.messages));
        }
    }

    private void checkMirror(DomainTypeMirror mirror) {
        mirror.getAllFields().forEach(this::checkField);
        mirror.getMethods().forEach(this::checkMethod);
    }

    private void checkField(FieldMirror field) {
        if (!field.getDeclaredByTypeName().startsWith("io.domainlifecycles.")) {
            this.check(field.getType(), String.format("The model class '%s' references an unknown domain type '%s' by the field declaration '%s'", field.getDeclaredByTypeName(), field.getType().getTypeName(), field.getName()));
        }
    }

    private void checkMethod(MethodMirror method) {
        if (!method.getDeclaredByTypeName().startsWith("io.domainlifecycles.")) {
            this.checkReturnType(method);
            method.getParameters().forEach(param -> this.checkMethodParam(method, (ParamMirror)param));
        }
    }

    private void checkReturnType(MethodMirror method) {
        this.check(method.getReturnType(), String.format("The model class '%s' references an unknown domain type '%s' by the method return type declaration of method '%s'", method.getDeclaredByTypeName(), method.getReturnType().getTypeName(), method.getName()));
    }

    private void checkMethodParam(MethodMirror method, ParamMirror param) {
        this.check(param.getType(), String.format("The model class '%s' references an unknown domain type '%s' by the method param declaration of method '%s'", method.getDeclaredByTypeName(), param.getType().getTypeName(), method.getName()));
    }

    private void check(AssertedContainableTypeMirror typeToCheck, String message) {
        if (DomainType.NON_DOMAIN.equals((Object)typeToCheck.getDomainType()) || DomainType.ENUM.equals((Object)typeToCheck.getDomainType())) {
            return;
        }
        if (this.domainMirror.getDomainTypeMirror(typeToCheck.getTypeName()).isEmpty() && !typeToCheck.getTypeName().startsWith("io.domainlifecycles.") && !typeToCheck.getTypeName().startsWith("java")) {
            this.messages.add(message);
        }
    }
}

