/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.visitor;

import io.domainlifecycles.domain.types.Identity;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.AggregateRootReferenceMirror;
import io.domainlifecycles.mirror.api.DomainObjectMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityMirror;
import io.domainlifecycles.mirror.api.EntityReferenceMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.ValueMirror;
import io.domainlifecycles.mirror.api.ValueReferenceMirror;
import io.domainlifecycles.mirror.visitor.DomainObjectVisitor;
import io.domainlifecycles.mirror.visitor.VisitorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextDomainObjectVisitor
implements DomainObjectVisitor {
    private static final Logger log = LoggerFactory.getLogger(ContextDomainObjectVisitor.class);
    private final VisitorContext visitorContext;
    private final DomainObjectMirror startingMirror;
    private boolean visitTypesOnlyOnce = true;
    private boolean ignoreStaticFields = true;
    private boolean ignoreHiddenFields = true;

    public ContextDomainObjectVisitor(DomainObjectMirror domainTypeMirror, boolean visitTypesOnlyOnce) {
        this(domainTypeMirror);
        this.visitTypesOnlyOnce = visitTypesOnlyOnce;
    }

    public ContextDomainObjectVisitor(DomainObjectMirror domainObjectMirror) {
        this.visitorContext = new VisitorContext(domainObjectMirror.getTypeName());
        this.startingMirror = domainObjectMirror;
    }

    public void start() {
        this.walkType(this.startingMirror);
    }

    private void walkType(DomainTypeMirror domainTypeMirror) {
        DomainTypeMirror currentTypeMirror = this.visitorContext.getCurrentType();
        boolean descend = this.enterDomainType(domainTypeMirror);
        this.visitorContext.enterType(domainTypeMirror);
        if (descend) {
            domainTypeMirror.getAllFields().stream().filter(fm -> !this.ignoreStaticFields || !fm.isStatic()).filter(fm -> !this.ignoreHiddenFields || !fm.isHidden()).forEach(this::walkField);
        }
        this.leaveDomainType(domainTypeMirror);
        this.visitorContext.leaveType(currentTypeMirror);
    }

    private boolean enterDomainType(DomainTypeMirror domainTypeMirror) {
        this.visitEnterAnyDomainType(domainTypeMirror);
        return switch (domainTypeMirror.getDomainType()) {
            case DomainType.ENTITY -> this.visitEnterEntity((EntityMirror)domainTypeMirror);
            case DomainType.ENUM, DomainType.VALUE_OBJECT, DomainType.IDENTITY -> this.visitEnterValue((ValueMirror)domainTypeMirror);
            case DomainType.AGGREGATE_ROOT -> this.visitEnterAggregateRoot((AggregateRootMirror)domainTypeMirror);
            default -> true;
        };
    }

    private void leaveDomainType(DomainTypeMirror domainTypeMirror) {
        switch (domainTypeMirror.getDomainType()) {
            case ENTITY: {
                this.visitLeaveEntity((EntityMirror)domainTypeMirror);
                break;
            }
            case ENUM: 
            case VALUE_OBJECT: 
            case IDENTITY: {
                this.visitLeaveValue((ValueMirror)domainTypeMirror);
                break;
            }
            case AGGREGATE_ROOT: {
                this.visitLeaveAggregateRoot((AggregateRootMirror)domainTypeMirror);
            }
        }
    }

    private void walkField(FieldMirror fieldMirror) {
        this.visitorContext.visitFieldStart(fieldMirror);
        switch (fieldMirror.getType().getDomainType()) {
            case ENTITY: {
                this.walkEntityReference((EntityReferenceMirror)fieldMirror);
                break;
            }
            case ENUM: 
            case VALUE_OBJECT: 
            case IDENTITY: {
                this.walkValueReference((ValueReferenceMirror)fieldMirror);
                break;
            }
            case AGGREGATE_ROOT: {
                this.walkAggregateRootReference((AggregateRootReferenceMirror)fieldMirror);
                break;
            }
            default: {
                this.walkBasicField(fieldMirror);
            }
        }
        this.visitorContext.visitFieldEnd(fieldMirror);
    }

    private void walkBasicField(FieldMirror fieldMirror) {
        this.visitBasic(fieldMirror);
    }

    private void walkValueReference(ValueReferenceMirror valueReferenceMirror) {
        EntityMirror entityMirror;
        boolean isIdentityField = false;
        if ((DomainType.ENTITY.equals((Object)this.getVisitorContext().getCurrentType().getDomainType()) || DomainType.AGGREGATE_ROOT.equals((Object)this.getVisitorContext().getCurrentType().getDomainType())) && (entityMirror = (EntityMirror)this.getVisitorContext().getCurrentType()).getIdentityField().isPresent() && entityMirror.getIdentityField().get().getName().equals(valueReferenceMirror.getName())) {
            isIdentityField = true;
        }
        if (isIdentityField) {
            this.visitEntityId(valueReferenceMirror);
        } else {
            this.visitValueReference(valueReferenceMirror);
        }
        if (!(this.visitTypesOnlyOnce && this.visitorContext.isAlreadyVisited(valueReferenceMirror.getType().getTypeName()) || Identity.class.getName().equals(valueReferenceMirror.getType().getTypeName()))) {
            try {
                this.walkType(valueReferenceMirror.getValue());
            }
            catch (Throwable t) {
                log.warn("Couldn't walk down " + valueReferenceMirror.getType().getTypeName() + "." + valueReferenceMirror.getName(), t);
            }
        }
    }

    private void walkEntityReference(EntityReferenceMirror entityReferenceMirror) {
        this.visitEntityReference(entityReferenceMirror);
        if (!this.visitTypesOnlyOnce || !this.visitorContext.isAlreadyVisited(entityReferenceMirror.getType().getTypeName())) {
            try {
                this.walkType(entityReferenceMirror.getEntity());
            }
            catch (Throwable t) {
                log.warn("Couldn't walk down " + entityReferenceMirror.getType().getTypeName() + "." + entityReferenceMirror.getName(), t);
            }
        }
    }

    private void walkAggregateRootReference(AggregateRootReferenceMirror aggregateRootReferenceMirror) {
        this.visitAggregateRootReference(aggregateRootReferenceMirror);
        if (!this.visitTypesOnlyOnce || !this.visitorContext.isAlreadyVisited(aggregateRootReferenceMirror.getType().getTypeName())) {
            try {
                this.walkType(aggregateRootReferenceMirror.getAggregateRoot());
            }
            catch (Throwable t) {
                log.warn("Couldn't walk down " + aggregateRootReferenceMirror.getType().getTypeName() + "." + aggregateRootReferenceMirror.getName(), t);
            }
        }
    }

    @Override
    public void visitEnterAnyDomainType(DomainTypeMirror domainTypeMirror) {
    }

    @Override
    public boolean visitEnterAggregateRoot(AggregateRootMirror aggregateRootMirror) {
        return true;
    }

    @Override
    public boolean visitEnterEntity(EntityMirror entityMirror) {
        return true;
    }

    @Override
    public boolean visitEnterValue(ValueMirror valueMirror) {
        return true;
    }

    @Override
    public void visitLeaveAggregateRoot(AggregateRootMirror aggregateRootMirror) {
    }

    @Override
    public void visitLeaveEntity(EntityMirror entityMirror) {
    }

    @Override
    public void visitLeaveValue(ValueMirror valueMirror) {
    }

    @Override
    public void visitAggregateRootReference(AggregateRootReferenceMirror aggregateRootReferenceMirror) {
    }

    @Override
    public void visitEntityReference(EntityReferenceMirror entityReferenceMirror) {
    }

    @Override
    public void visitValueReference(ValueReferenceMirror valueReferenceMirror) {
    }

    @Override
    public void visitBasic(FieldMirror basicFieldMirror) {
    }

    @Override
    public void visitEntityId(FieldMirror idFieldMirror) {
    }

    public VisitorContext getVisitorContext() {
        return this.visitorContext;
    }

    public void setIgnoreStaticFields(boolean ignoreStaticFields) {
        this.ignoreStaticFields = ignoreStaticFields;
    }

    public void setIgnoreHiddenFields(boolean ignoreHiddenFields) {
        this.ignoreHiddenFields = ignoreHiddenFields;
    }

    public void setVisitTypesOnlyOnce(boolean visitTypesOnlyOnce) {
        this.visitTypesOnlyOnce = visitTypesOnlyOnce;
    }
}

