/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.mirror.visitor;

import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class VisitorContext {
    private final List<FieldMirror> currentPath = new ArrayList<FieldMirror>();
    private DomainTypeMirror currentDomainTypeMirror;
    public final String startingTypeName;
    private final Set<DomainTypeMirror> alreadyVisitedTypeMirrors = new HashSet<DomainTypeMirror>();
    private Optional<FieldMirror> currentFieldMirror;

    protected VisitorContext(String startingTypeName) {
        this.startingTypeName = startingTypeName;
    }

    protected void enterType(DomainTypeMirror type) {
        this.currentDomainTypeMirror = type;
        this.alreadyVisitedTypeMirrors.add(type);
    }

    protected void leaveType(DomainTypeMirror type) {
        this.currentDomainTypeMirror = type;
    }

    protected void visitFieldStart(FieldMirror fieldMirror) {
        this.currentFieldMirror = Optional.of(fieldMirror);
        this.currentPath.add(fieldMirror);
    }

    protected void visitFieldEnd(FieldMirror fieldMirror) {
        this.currentFieldMirror = Optional.empty();
        this.removeLastPathEntry();
    }

    private void removeLastPathEntry() {
        if (!this.currentPath.isEmpty()) {
            this.currentPath.remove(this.currentPath.size() - 1);
        }
    }

    public Optional<FieldMirror> getCurrentFieldMirror() {
        return this.currentFieldMirror;
    }

    public List<FieldMirror> getCurrentPath() {
        return this.currentPath;
    }

    public DomainTypeMirror getCurrentType() {
        return this.currentDomainTypeMirror;
    }

    public boolean isAlreadyVisited(String typeName) {
        return this.alreadyVisitedTypeMirrors.stream().map(DomainTypeMirror::getTypeName).anyMatch(t -> t.equals(typeName));
    }
}

