/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.reflect;

import io.domainlifecycles.reflect.Arities;
import io.domainlifecycles.reflect.MemberSelect;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JavaReflect
extends Enum<JavaReflect> {
    public static final String CLASS_FILE_EXT = ".class";
    public static final int BYTE_SIZE = 1;
    public static final int BOOLEAN_SIZE = 1;
    public static final int CHAR_SIZE = 2;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int FLOAT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int DOUBLE_SIZE = 8;
    public static final int REFERENCE_SIZE = 4;
    private static final Pattern packagePattern;
    private static final Class<?>[][] PRIMITIVES;
    private static final /* synthetic */ JavaReflect[] $VALUES;

    public static JavaReflect[] values() {
        return (JavaReflect[])$VALUES.clone();
    }

    public static JavaReflect valueOf(String name) {
        return Enum.valueOf(JavaReflect.class, name);
    }

    public static String className(Class<?> type) {
        return type == null ? "" : type.getSimpleName();
    }

    public static String qualifiedClassName(Class<?> type) {
        return type == null ? "" : type.getName();
    }

    public static boolean isValidPackage(String packageName) {
        return packagePattern.matcher(packageName).matches();
    }

    public static String packageName(Class<?> type) {
        return JavaReflect.packageName(type.getName());
    }

    public static String packageName(String fullClassName) {
        int lastDot = fullClassName.lastIndexOf(46);
        return lastDot < 0 ? "" : fullClassName.substring(0, lastDot);
    }

    public static boolean isSamePackage(Class<?> type1, Class<?> type2) {
        if (Objects.requireNonNull(type1) == Objects.requireNonNull(type2)) {
            return true;
        }
        if (type1.getClassLoader() != type2.getClassLoader()) {
            return false;
        }
        return Objects.equals(type1.getPackageName(), type2.getPackageName());
    }

    public static boolean isPublic(Class<?> type) {
        return JavaReflect.hasModifiers(type, 1);
    }

    public static boolean isPublic(Member member) {
        return JavaReflect.hasModifiers(member, 1);
    }

    public static boolean isProtected(Class<?> type) {
        return JavaReflect.hasModifiers(type, 4);
    }

    public static boolean isProtected(Member member) {
        return JavaReflect.hasModifiers(member, 4);
    }

    public static boolean isPrivate(Class<?> type) {
        return JavaReflect.hasModifiers(type, 2);
    }

    public static boolean isPrivate(Member member) {
        return JavaReflect.hasModifiers(member, 2);
    }

    public static boolean isPackagePrivate(Class<?> type) {
        return JavaReflect.isPackagePrivate(type.getModifiers());
    }

    public static boolean isPackagePrivate(Member member) {
        return JavaReflect.isPackagePrivate(member.getModifiers());
    }

    public static boolean isPackagePrivate(int mod) {
        return (mod & 7) == 0;
    }

    public static boolean isAbstract(Class<?> type) {
        return JavaReflect.hasModifiers(type, 1024);
    }

    public static boolean isAbstract(Member member) {
        return JavaReflect.hasModifiers(member, 1024);
    }

    public static boolean isStatic(Class<?> type) {
        return JavaReflect.hasModifiers(type, 8);
    }

    public static boolean isStatic(Member member) {
        return JavaReflect.hasModifiers(member, 8);
    }

    public static boolean notStatic(Member member) {
        return !JavaReflect.hasModifiers(member, 8);
    }

    public static boolean isFinal(Class<?> type) {
        return JavaReflect.hasModifiers(type, 16);
    }

    public static boolean isFinal(Member member) {
        return JavaReflect.hasModifiers(member, 16);
    }

    public static boolean isSynchronized(Method method) {
        return JavaReflect.hasModifiers(method, 32);
    }

    public static boolean isSynchronized(Constructor<?> ctor) {
        return JavaReflect.hasModifiers(ctor, 32);
    }

    public static boolean isVolatile(Field field) {
        return JavaReflect.hasModifiers(field, 64);
    }

    public static boolean isTransient(Field field) {
        return JavaReflect.hasModifiers(field, 128);
    }

    public static boolean isInterfaceType(Class<?> type) {
        return type != null && type.isInterface();
    }

    public static boolean isAnnotationType(Class<?> type) {
        return type != null && type.isAnnotation();
    }

    public static boolean isLambdaType(Class<?> type) {
        if (!type.isInterface()) {
            return false;
        }
        long count = JavaReflect.methods(type, MemberSelect.HIERARCHY).stream().filter(x -> x.getDeclaringClass() != Arities.Arity.class).filter(x -> JavaReflect.canLambda(x.getModifiers())).count();
        return count == 1L;
    }

    public static boolean isLambdaMethod(Method method) {
        Class<?> declaring = method.getDeclaringClass();
        return declaring.isInterface() && JavaReflect.isLambdaType(declaring);
    }

    public static Optional<Method> lambdaMethod(Class<?> type) {
        if (!JavaReflect.isLambdaType(type)) {
            return Optional.empty();
        }
        return JavaReflect.methods(type, MemberSelect.HIERARCHY).stream().filter(x -> x.getDeclaringClass() != Arities.Arity.class).filter(x -> JavaReflect.canLambda(x.getModifiers())).findFirst();
    }

    private static boolean canLambda(int mod) {
        return Modifier.isPublic(mod) && (mod & 0x409) != 1;
    }

    public static Predicate<Method> canLambda() {
        return method -> JavaReflect.canLambda(method.getModifiers());
    }

    public static boolean isClassType(Class<?> type) {
        return !type.isPrimitive() && !type.isArray();
    }

    public static boolean isTopLevelType(Class<?> type) {
        return type != null && type.getDeclaringClass() == null && !JavaReflect.isAnonymousType(type) && !JavaReflect.isLocalType(type);
    }

    public static boolean isMemberType(Class<?> type) {
        return type != null && type.isMemberClass();
    }

    public static boolean isEnumType(Class<?> type) {
        return type != null && type.isEnum();
    }

    public static boolean isAnonymousType(Class<?> type) {
        return type != null && type.isAnonymousClass();
    }

    public static boolean isLocalType(Class<?> type) {
        return type != null && type.isLocalClass();
    }

    public static boolean isBoxedType(Class<?> type) {
        return !type.isPrimitive() && !type.isArray() && type == Boolean.class || type == Byte.class || type == Short.class || type == Character.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == Void.class;
    }

    public static boolean isArray(Object o) {
        return o != null && JavaReflect.isArrayType(o.getClass());
    }

    public static boolean isArrayType(Class<?> type) {
        return type != null && type.isArray();
    }

    public static boolean isPrimitiveArrayType(Class<?> type) {
        return type != null && type.isArray() && JavaReflect.isPrimitiveType(type.getComponentType());
    }

    public static boolean isReferenceArrayType(Class<?> type) {
        return type != null && type.isArray() && !JavaReflect.isPrimitiveType(type.getComponentType());
    }

    public static boolean isMultidimensionalArrayType(Class<?> type) {
        return type != null && type.isArray() && JavaReflect.isArrayType(type.getComponentType());
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return type != null && type.isPrimitive();
    }

    public static boolean isCategoryI(Class<?> type) {
        return type != null && type != Long.TYPE && type != Double.TYPE;
    }

    public static boolean isCategoryII(Class<?> type) {
        return type == Long.TYPE || type == Double.TYPE;
    }

    public static boolean isNumericType(Class<?> type) {
        return type != Void.TYPE && !Object.class.isAssignableFrom(type);
    }

    public static boolean isIntegralType(Class<?> type) {
        return JavaReflect.isNumericType(type) && !JavaReflect.isFloatingType(type);
    }

    public static boolean isSignedType(Class<?> type) {
        return type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE;
    }

    public static boolean isUnsignedType(Class<?> type) {
        return type == Boolean.TYPE || type == Character.TYPE;
    }

    public static boolean isFloatingType(Class<?> type) {
        return type == Float.TYPE || type == Double.TYPE;
    }

    private static boolean hasModifiers(Class<?> type, int mod) {
        return (mod & type.getModifiers()) != 0;
    }

    private static boolean hasModifiers(Member member, int mod) {
        return (mod & member.getModifiers()) != 0;
    }

    public static Optional<Class<?>> componentType(Class<?> type) {
        return Optional.ofNullable(type.getComponentType());
    }

    public static Optional<Class<?>> elementType(Class<?> type) {
        if (!JavaReflect.isArrayType(Objects.requireNonNull(type))) {
            return Optional.empty();
        }
        Class<?> elementType = type;
        while (elementType.getComponentType() != null) {
            elementType = elementType.getComponentType();
        }
        return Optional.of(elementType);
    }

    public static int arrayRank(Class<?> type) {
        int rank = 0;
        Class<?> elementType = type;
        while (elementType.isArray()) {
            elementType = elementType.getComponentType();
            ++rank;
        }
        return rank;
    }

    public static Optional<Type> getFirstParameterType(Type genericType) {
        if (ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            return Optional.of(((ParameterizedType)genericType).getActualTypeArguments()[0]);
        }
        return Optional.empty();
    }

    public static boolean isGeneric(Class<?> type) {
        return type.getTypeParameters().length > 0;
    }

    public static boolean isGeneric(Constructor<?> ctor) {
        Type[] ptypes = ctor.getGenericParameterTypes();
        for (int i = 0; i < ptypes.length; ++i) {
            if (!JavaReflect.isGenericType(ptypes[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isGeneric(Method method) {
        if (JavaReflect.isGenericType(method.getGenericReturnType())) {
            return true;
        }
        Type[] ptypes = method.getGenericParameterTypes();
        for (int i = 0; i < ptypes.length; ++i) {
            if (!JavaReflect.isGenericType(ptypes[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isGeneric(Field field) {
        return JavaReflect.isGenericType(field.getGenericType());
    }

    private static boolean isGenericType(Type type) {
        return type instanceof TypeVariable || type instanceof GenericArrayType;
    }

    public static Optional<Class<?>> superclass(Class<?> type) {
        return type == Object.class ? Optional.empty() : Optional.ofNullable(type.getSuperclass());
    }

    public static List<Class<?>> allSuperclasses(Class<?> type) {
        return JavaReflect.allSuperclasses(type, false);
    }

    public static List<Class<?>> allSuperclasses(Class<?> type, boolean include) {
        return new SuperclassIterator(include ? type : type.getSuperclass()).toList();
    }

    public static List<Class<?>> interfaces(Class<?> type) {
        return List.of(type.getInterfaces());
    }

    public static List<Class<?>> allInterfaces(Class<?> type) {
        return new InterfaceIterator(type).toList();
    }

    public static List<Class<?>> supertypes(Class<?> type) {
        ArrayList classes = new ArrayList();
        classes.add(type.getSuperclass());
        classes.addAll(List.of(type.getInterfaces()));
        return List.of((Class[])classes.toArray(Class[]::new));
    }

    public static List<Class<?>> allSupertypes(Class<?> type) {
        return new SupertypeIterator(type).toList();
    }

    public static List<Class<?>> allSupertypes(Class<?> type, boolean include) {
        List<Class<?>> supertypes = new SupertypeIterator(type).toList();
        if (include) {
            ArrayList allSupertypes = new ArrayList();
            allSupertypes.add(type);
            allSupertypes.addAll(supertypes);
            return List.of((Class[])allSupertypes.toArray(Class[]::new));
        }
        return supertypes;
    }

    public static Class<?> commonSupertype(Class<?> type1, Class<?> type2) {
        if (type1 == type2) {
            return type1;
        }
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        return Object.class;
    }

    public static boolean isSubclassOf(Class<?> queryClass, Class<?> ofClass) {
        while (queryClass != null) {
            if (queryClass == ofClass) {
                return true;
            }
            queryClass = queryClass.getSuperclass();
        }
        return false;
    }

    public static Optional<Class<?>> enclosingType(Class<?> type) {
        return Optional.ofNullable(type).map(Class::getEnclosingClass);
    }

    public static List<Class<?>> allEnclosingTypes(Member member) {
        return JavaReflect.allEnclosingTypes(member.getDeclaringClass(), true);
    }

    public static List<Class<?>> allEnclosingTypes(Class<?> type) {
        return JavaReflect.allEnclosingTypes(type, false);
    }

    public static List<Class<?>> allEnclosingTypes(Class<?> type, boolean include) {
        ArrayList classes = new ArrayList();
        boolean ix = false;
        for (Class<?> cls = include ? type : type.getEnclosingClass(); cls != null; cls = cls.getEnclosingClass()) {
            classes.add(cls);
        }
        return List.of((Class[])classes.toArray(Class[]::new));
    }

    public static List<Field> fields(Class<?> declaring) {
        return JavaReflect.fields(declaring, MemberSelect.DECLARED);
    }

    public static List<Field> fields(Class<?> declaring, MemberSelect select) {
        Objects.requireNonNull(declaring);
        switch (Objects.requireNonNull(select)) {
            case DECLARED: {
                return List.of(declaring.getDeclaredFields());
            }
            case ACCESSIBLE: {
                return List.of(declaring.getFields());
            }
            case VISIBLE: {
                List<Field> fields = JavaReflect.allSupertypes(declaring).stream().flatMap(x -> Stream.of(x.getDeclaredFields())).filter(x -> JavaReflect.isPublic(x) || JavaReflect.isProtected(x) || JavaReflect.isPackagePrivate(x) && JavaReflect.isSamePackage(x.getDeclaringClass(), declaring)).toList();
                ArrayList<Field> visibleFields = new ArrayList<Field>();
                visibleFields.addAll(List.of(declaring.getDeclaredFields()));
                visibleFields.addAll(fields);
                return List.of((Field[])visibleFields.toArray(Field[]::new));
            }
            case HIERARCHY: {
                return JavaReflect.allSupertypes(declaring, true).stream().flatMap(x -> Stream.of(x.getDeclaredFields())).collect(Collectors.toList());
            }
        }
        throw new IllegalStateException();
    }

    public static Optional<Field> findField(Class<?> declaring, String name) {
        return JavaReflect.findField(declaring, MemberSelect.DECLARED, name);
    }

    public static Optional<Field> findField(Class<?> declaring, MemberSelect select, String name) {
        return JavaReflect.fields(declaring, select).stream().filter(x -> x.getName().equals(name)).findFirst();
    }

    public static List<Method> methods(Class<?> declaring) {
        return JavaReflect.methods(declaring, MemberSelect.DECLARED);
    }

    public static List<Method> methods(Class<?> declaring, MemberSelect select) {
        Objects.requireNonNull(declaring);
        switch (Objects.requireNonNull(select)) {
            case DECLARED: {
                return List.of(declaring.getDeclaredMethods());
            }
            case ACCESSIBLE: {
                return List.of(declaring.getMethods());
            }
            case VISIBLE: {
                List methods = JavaReflect.allSupertypes(declaring).stream().flatMap(x -> Stream.of(x.getDeclaredMethods())).filter(x -> JavaReflect.isPublic(x) || JavaReflect.isProtected(x) || JavaReflect.isPackagePrivate(x) && JavaReflect.isSamePackage(x.getDeclaringClass(), declaring)).collect(Collectors.toList());
                ArrayList<Method> visibleMethods = new ArrayList<Method>();
                visibleMethods.addAll(List.of(declaring.getDeclaredMethods()));
                visibleMethods.addAll(methods);
                return List.of((Method[])visibleMethods.toArray(Method[]::new));
            }
            case HIERARCHY: {
                return JavaReflect.allSupertypes(declaring, true).stream().flatMap(x -> {
                    try {
                        return Stream.of(x.getDeclaredMethods());
                    }
                    catch (Throwable ex) {
                        return Stream.empty();
                    }
                }).collect(Collectors.toList());
            }
        }
        throw new IllegalStateException();
    }

    public static Optional<Method> findMethod(Class<?> declaring, String name, Class<?> ... parameters) {
        return JavaReflect.findMethod(declaring, MemberSelect.DECLARED, name, parameters);
    }

    public static Optional<Method> findMethod(Class<?> declaring, MemberSelect select, String name, Class<?> ... parameters) {
        return JavaReflect.methods(declaring, select).stream().filter(x -> x.getName().equals(name) && JavaReflect.isAssignable(x.getParameterTypes(), parameters, false)).findFirst();
    }

    public static List<Class<?>> classes(Class<?> declaring) {
        return JavaReflect.classes(declaring, MemberSelect.DECLARED);
    }

    public static List<Class<?>> classes(Class<?> declaring, MemberSelect select) {
        Objects.requireNonNull(declaring);
        switch (Objects.requireNonNull(select)) {
            case DECLARED: {
                return List.of(declaring.getDeclaredClasses());
            }
            case ACCESSIBLE: {
                return List.of(declaring.getClasses());
            }
            case VISIBLE: {
                List classes = JavaReflect.allSupertypes(declaring).stream().flatMap(x -> Stream.of(x.getDeclaredClasses())).filter(x -> JavaReflect.isPublic(x) || JavaReflect.isProtected(x) || JavaReflect.isPackagePrivate(x) && JavaReflect.isSamePackage(x.getDeclaringClass(), declaring)).collect(Collectors.toList());
                ArrayList<Class<Object>> declaredList = new ArrayList<Class<Object>>();
                declaredList.addAll(List.of(declaring.getDeclaredClasses()));
                declaredList.addAll(classes);
                return List.of((Class[])declaredList.toArray(Class[]::new));
            }
            case HIERARCHY: {
                return JavaReflect.allSupertypes(declaring, true).stream().flatMap(x -> Stream.of(x.getDeclaredClasses())).collect(Collectors.toList());
            }
        }
        throw new IllegalStateException();
    }

    public static List<Constructor<?>> constructors(Class<?> declaring, MemberSelect select) {
        return List.of(declaring.getDeclaredConstructors());
    }

    public static Optional<Constructor<?>> findConstructor(Class<?> declaring, Class<?> ... parameters) {
        return JavaReflect.constructors(declaring, null).stream().filter(x -> JavaReflect.isAssignable(x.getParameterTypes(), parameters, false)).findFirst();
    }

    public static Class<?> boxedType(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Void.TYPE) {
                return Void.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            return Double.class;
        }
        return type;
    }

    public static Class<?> unboxedType(Class<?> type) {
        if (!Objects.requireNonNull(type).isArray()) {
            if (type == Void.class) {
                return Void.TYPE;
            }
            if (type == Boolean.class) {
                return Boolean.TYPE;
            }
            if (type == Byte.class) {
                return Byte.TYPE;
            }
            if (type == Short.class) {
                return Short.TYPE;
            }
            if (type == Character.class) {
                return Character.TYPE;
            }
            if (type == Integer.class) {
                return Integer.TYPE;
            }
            if (type == Long.class) {
                return Long.TYPE;
            }
            if (type == Float.class) {
                return Float.TYPE;
            }
            return Double.TYPE;
        }
        return type;
    }

    public static boolean isAssignable(Class<?> lhs, Class<?> rhs) {
        return JavaReflect.isAssignable(lhs, rhs, true);
    }

    public static boolean isAssignable(Class<?> lhs, Class<?> rhs, boolean boxing) {
        if (rhs == null) {
            return false;
        }
        if (lhs == null) {
            return !rhs.isPrimitive();
        }
        if (boxing) {
            if (lhs.isPrimitive() && !rhs.isPrimitive() && (lhs = JavaReflect.boxedType(lhs)) == null) {
                return false;
            }
            if (rhs.isPrimitive() && !lhs.isPrimitive() && (lhs = JavaReflect.unboxedType(lhs)) == null) {
                return false;
            }
        }
        if (lhs.equals(rhs)) {
            return true;
        }
        if (lhs.isPrimitive()) {
            if (!rhs.isPrimitive()) {
                return false;
            }
            if (lhs == Integer.TYPE) {
                return rhs == Long.TYPE || rhs == Float.TYPE || rhs == Double.TYPE;
            }
            if (lhs == Long.TYPE) {
                return rhs == Float.TYPE || rhs == Double.TYPE;
            }
            if (lhs == Boolean.TYPE) {
                return false;
            }
            if (lhs == Double.TYPE) {
                return false;
            }
            if (lhs == Float.TYPE) {
                return rhs == Double.TYPE;
            }
            if (lhs == Character.TYPE || lhs == Short.TYPE) {
                return rhs == Integer.TYPE || rhs == Long.TYPE || rhs == Float.TYPE || rhs == Double.TYPE;
            }
            if (lhs == Byte.TYPE) {
                return rhs == Short.TYPE || rhs == Integer.TYPE || rhs == Long.TYPE || rhs == Float.TYPE || rhs == Double.TYPE;
            }
            throw new IllegalStateException();
        }
        return lhs.isAssignableFrom(rhs);
    }

    public static boolean isAssignable(Class<?>[] lhs, Class<?>[] rhs) {
        return JavaReflect.isAssignable(lhs, rhs, true);
    }

    public static boolean isAssignable(Class<?>[] lhs, Class<?>[] rhs, boolean boxing) {
        if (lhs.length != rhs.length) {
            return false;
        }
        boolean canAssign = true;
        for (int i = 0; canAssign && i < lhs.length; ++i) {
            canAssign = JavaReflect.isAssignable(lhs[i], rhs[i], boxing);
        }
        return canAssign;
    }

    public static Optional<Path> sourceCode(Class<?> type) {
        URL url;
        Path path;
        CodeSource src;
        Objects.requireNonNull(type);
        ProtectionDomain dom = type.getProtectionDomain();
        if (dom != null && (src = dom.getCodeSource()) != null && Files.exists(path = Paths.get((url = src.getLocation()).getFile(), new String[0]), new LinkOption[0])) {
            return Optional.of(path);
        }
        return Optional.empty();
    }

    public static Optional<InputStream> byteCode(Class<?> type) {
        String rsc = "/" + type.getName().replace('.', '/') + CLASS_FILE_EXT;
        return Optional.ofNullable(type.getResourceAsStream(rsc));
    }

    private static /* synthetic */ JavaReflect[] $values() {
        return new JavaReflect[0];
    }

    static {
        $VALUES = JavaReflect.$values();
        packagePattern = Pattern.compile("^[a-z]+(\\.[a-zA-Z_][a-zA-Z0-9_]*)*$");
        PRIMITIVES = new Class[][]{{Void.TYPE, Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}, {Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}, {Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE}, {Float.TYPE, Double.TYPE}, {Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}, {Boolean.TYPE, Character.TYPE}, {Long.TYPE, Double.TYPE}, {Integer.TYPE, Float.TYPE}, {Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE}, {Void.TYPE}};
    }

    public static final class SuperclassIterator
    implements Iterator<Class<?>> {
        private Class<?> superclass;

        public SuperclassIterator(Class<?> type) {
            this.superclass = type;
        }

        @Override
        public final boolean hasNext() {
            return null != this.superclass && this.superclass != Object.class;
        }

        @Override
        public final Class<?> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Class<?> next = this.superclass;
            this.superclass = next.getSuperclass();
            return next;
        }

        @Override
        public final void forEachRemaining(Consumer<? super Class<?>> action) {
            Objects.requireNonNull(action);
            for (Class<?> next = this.superclass; next != null && next != Object.class; next = next.getSuperclass()) {
                action.accept(next);
            }
            this.superclass = null;
        }

        public List<Class<?>> toList() {
            ArrayList superClasses = new ArrayList();
            while (this.hasNext()) {
                superClasses.add((Class<?>)this.next());
            }
            return superClasses;
        }
    }

    public static final class InterfaceIterator
    implements Iterator<Class<?>> {
        private final LinkedList<Class<?>> stack = new LinkedList();
        private final HashSet<Class<?>> visited;

        public InterfaceIterator(Class<?> type) {
            this(new HashSet(), type);
        }

        public InterfaceIterator(HashSet<Class<?>> visited, Class<?> type) {
            this.visited = Objects.requireNonNull(visited);
            Stream.of(type.getInterfaces()).filter(visited::add).forEach(this.stack::push);
        }

        @Override
        public final boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public final Class<?> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Class<?> next = this.stack.pop();
            Stream.of(next.getInterfaces()).filter(this.visited::add).forEach(this.stack::push);
            return next;
        }

        public List<Class<?>> toList() {
            ArrayList superInterfaces = new ArrayList();
            while (this.hasNext()) {
                superInterfaces.add((Class<?>)this.next());
            }
            return superInterfaces;
        }
    }

    public static final class SupertypeIterator
    implements Iterator<Class<?>> {
        private final Set<Class<?>> visited = new LinkedHashSet();
        private final Queue<Class<?>> workset = new LinkedList();

        public SupertypeIterator(Class<?> type) {
            if (!type.isInterface()) {
                this.push(type.getSuperclass());
            }
            this.push(type.getInterfaces());
        }

        @Override
        public final boolean hasNext() {
            return !this.workset.isEmpty();
        }

        @Override
        public final Class<?> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Class<?> next = Objects.requireNonNull(this.workset.poll());
            ArrayList supertypes = new ArrayList();
            supertypes.add(next.getSuperclass());
            supertypes.addAll(List.of(next.getInterfaces()));
            supertypes.forEach(this::push);
            return next;
        }

        private void push(Class<?> type) {
            if (type != null && type != Object.class && this.visited.add(type)) {
                this.workset.add(type);
            }
        }

        private void push(Class<?> ... types) {
            for (int i = 0; i < types.length; ++i) {
                this.push(types[i]);
            }
        }

        public List<Class<?>> toList() {
            ArrayList superTypes = new ArrayList();
            while (this.hasNext()) {
                superTypes.add((Class<?>)this.next());
            }
            return superTypes;
        }
    }

    public static enum PrimitiveKind {
        PRIMITIVE,
        NUMERIC,
        INTEGRAL,
        FLOATING,
        SIGNED,
        UNSIGNED,
        DOUBLE_WORD,
        SINGLE_WORD,
        SUB_WORD,
        VOID;

    }
}

