/*
 * Decompiled with CFR 0.152.
 */
package io.doorbell.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.Html;
import android.text.method.LinkMovementMethod;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import io.doorbell.android.DoorbellApi;
import io.doorbell.android.callbacks.OnShowCallback;
import io.doorbell.android.manavo.rest.RestCallback;
import java.lang.reflect.Method;
import org.json.JSONException;
import org.json.JSONObject;

public class Doorbell
extends AlertDialog.Builder {
    private Activity mActivity;
    private Context mContext;
    private String mMessageHint = "What's on your mind?";
    private String mEmailHint = "Your email address";
    private int mEmailFieldVisibility = 0;
    private int mPoweredByVisibility = 0;
    private OnShowCallback mOnShowCallback = null;
    private String mEmail = "";
    private String mName = "";
    private EditText mMessageField;
    private EditText mEmailField;
    private JSONObject mProperties;
    private DoorbellApi mApi;

    public Doorbell(Activity activity, long id, String privateKey) {
        super((Context)activity);
        this.mApi = new DoorbellApi(activity);
        this.mProperties = new JSONObject();
        this.mActivity = activity;
        this.mContext = activity;
        this.setAppId(id);
        this.setApiKey(privateKey);
        this.setTitle("Feedback");
        this.setCancelable(true);
        this.buildProperties();
        PackageManager manager = activity.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(activity.getPackageName(), 0);
            this.addProperty("App Version Name", info.versionName);
            this.addProperty("App Version Code", info.versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
    }

    private void buildProperties() {
        this.addProperty("Model", Build.MODEL);
        this.addProperty("Android Version", Build.VERSION.RELEASE);
        try {
            WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            SupplicantState supState = wifiInfo.getSupplicantState();
            this.addProperty("WiFi enabled", supState);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean mobileDataEnabled = false;
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        try {
            Class<?> cmClass = Class.forName(cm.getClass().getName());
            Method method = cmClass.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
            method.setAccessible(true);
            mobileDataEnabled = (Boolean)method.invoke((Object)cm, new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.addProperty("Mobile Data enabled", mobileDataEnabled);
        try {
            LocationManager manager = (LocationManager)this.mContext.getSystemService("location");
            boolean gpsEnabled = manager.isProviderEnabled("gps");
            this.addProperty("GPS enabled", gpsEnabled);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            DisplayMetrics metrics = new DisplayMetrics();
            this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            String resolution = Integer.toString(metrics.widthPixels) + "x" + Integer.toString(metrics.heightPixels);
            this.addProperty("Screen Resolution", resolution);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String activityName = this.mActivity.getClass().getSimpleName();
            this.addProperty("Activity", activityName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Doorbell addProperty(String key, Object value) {
        try {
            this.mProperties.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return this;
    }

    public Doorbell setAppId(long id) {
        this.mApi.setAppId(id);
        return this;
    }

    public Doorbell setApiKey(String key) {
        this.mApi.setApiKey(key);
        return this;
    }

    public Doorbell setEmailFieldVisibility(int visibility) {
        this.mEmailFieldVisibility = visibility;
        return this;
    }

    public Doorbell setPoweredByVisibility(int visibility) {
        this.mPoweredByVisibility = visibility;
        return this;
    }

    public Doorbell setEmailHint(String emailHint) {
        this.mEmailHint = emailHint;
        return this;
    }

    public Doorbell setMessageHint(String messageHint) {
        this.mMessageHint = messageHint;
        return this;
    }

    public Doorbell setEmail(String email) {
        this.mEmail = email;
        return this;
    }

    public Doorbell setOnShowCallback(OnShowCallback onShowCallback) {
        this.mOnShowCallback = onShowCallback;
        return this;
    }

    public Doorbell setName(String name) {
        this.mName = name;
        return this;
    }

    public Doorbell impression() {
        this.mApi.impression();
        return this;
    }

    public AlertDialog show() {
        this.mApi.open();
        LinearLayout mainLayout = new LinearLayout(this.mContext);
        mainLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        mainLayout.setOrientation(1);
        this.mMessageField = new EditText(this.mContext);
        this.mMessageField.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mMessageField.setHint((CharSequence)this.mMessageHint);
        this.mMessageField.setMinLines(2);
        this.mMessageField.setGravity(48);
        this.mMessageField.setInputType(this.mMessageField.getInputType() | 0x4000);
        mainLayout.addView((View)this.mMessageField);
        this.mEmailField = new EditText(this.mContext);
        this.mEmailField.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mEmailField.setHint((CharSequence)this.mEmailHint);
        this.mEmailField.setText((CharSequence)this.mEmail);
        this.mEmailField.setInputType(33);
        this.mEmailField.setVisibility(this.mEmailFieldVisibility);
        mainLayout.addView((View)this.mEmailField);
        TextView poweredBy = new TextView(this.mContext);
        poweredBy.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        poweredBy.setText((CharSequence)Html.fromHtml((String)"Powered by <a href=\"https://doorbell.io\">Doorbell.io</a>"));
        poweredBy.setPadding(7, 7, 7, 7);
        poweredBy.setVisibility(this.mPoweredByVisibility);
        poweredBy.setMovementMethod(LinkMovementMethod.getInstance());
        mainLayout.addView((View)poweredBy);
        this.setView((View)mainLayout);
        this.setPositiveButton("Send", null);
        this.setNegativeButton("Cancel", null);
        final AlertDialog dialog = super.show();
        Button positiveButton = dialog.getButton(-1);
        positiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Doorbell.this.mApi.setLoadingMessage("Sending...");
                Doorbell.this.mApi.setCallback(new RestCallback(){

                    @Override
                    public void success(Object obj) {
                        Toast.makeText((Context)Doorbell.this.mContext, (CharSequence)obj.toString(), (int)1).show();
                        Doorbell.this.mMessageField.setText((CharSequence)"");
                        Doorbell.this.mProperties = new JSONObject();
                        dialog.hide();
                    }
                });
                Doorbell.this.mApi.sendFeedback(Doorbell.this.mMessageField.getText().toString(), Doorbell.this.mEmailField.getText().toString(), Doorbell.this.mProperties, Doorbell.this.mName);
            }
        });
        if (this.mOnShowCallback != null) {
            this.mOnShowCallback.handle();
        }
        return dialog;
    }
}

